/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.model;

import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.picketlink.common.model.AbstractResourceDefinition;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.common.model.validator.AlternativeAttributeValidationStepHandler;
import org.wildfly.extension.picketlink.federation.FederationExtension;

public abstract class AbstractFederationResourceDefinition
extends AbstractResourceDefinition {
    protected AbstractFederationResourceDefinition(ModelElement modelElement, OperationStepHandler addHandler, OperationStepHandler removeHandler, SimpleAttributeDefinition ... attributes) {
        super(modelElement, addHandler, removeHandler, FederationExtension.getResourceDescriptionResolver(modelElement.getName()), attributes);
    }

    protected AbstractFederationResourceDefinition(ModelElement modelElement, String name, OperationStepHandler addHandler, OperationStepHandler removeHandler, SimpleAttributeDefinition ... attributes) {
        super(modelElement, name, addHandler, removeHandler, FederationExtension.getResourceDescriptionResolver(modelElement.getName()), attributes);
    }

    @Override
    protected OperationStepHandler createAttributeWriterHandler() {
        List<SimpleAttributeDefinition> attributes = this.getAttributes();
        final List<AttributeDefinition> alternativeAttributes = this.getAlternativesAttributes();
        return new ReloadRequiredWriteAttributeHandler(attributes.toArray(new AttributeDefinition[attributes.size()])){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                if (!alternativeAttributes.isEmpty()) {
                    context.addStep((OperationStepHandler)new AlternativeAttributeValidationStepHandler(alternativeAttributes.toArray(new AttributeDefinition[alternativeAttributes.size()])), OperationContext.Stage.MODEL);
                }
                AbstractFederationResourceDefinition.this.doRegisterModelWriteAttributeHandler(context, operation);
                super.execute(context, operation);
            }
        };
    }

    protected void doRegisterModelWriteAttributeHandler(OperationContext context, ModelNode operation) {
    }
}

