/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.bulkhead;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.bulkhead.BulkheadBase;
import java.util.concurrent.Semaphore;

public class SemaphoreBulkhead<V>
extends BulkheadBase<V> {
    private final Semaphore semaphore;

    public SemaphoreBulkhead(FaultToleranceStrategy<V> delegate, String description, int size, BulkheadBase.MetricsRecorder metricsRecorder) {
        super(description, delegate, metricsRecorder);
        this.semaphore = new Semaphore(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V apply(InvocationContext<V> ctx) throws Exception {
        if (this.semaphore.tryAcquire()) {
            this.recorder.bulkheadEntered();
            long startTime = System.nanoTime();
            try {
                V v = this.delegate.apply(ctx);
                return v;
            }
            finally {
                this.semaphore.release();
                this.recorder.bulkheadLeft(System.nanoTime() - startTime);
            }
        }
        this.recorder.bulkheadRejected();
        throw this.bulkheadRejected();
    }
}

