/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Lock;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.AbstractWorkspaceImpl;
import org.hibernate.search.backend.impl.lucene.IndexWriterDelegate;
import org.hibernate.search.backend.impl.lucene.LuceneBackendResources;
import org.hibernate.search.exception.impl.ErrorContextBuilder;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

final class LuceneBackendQueueTask
implements Runnable {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final Lock modificationLock;
    private final LuceneBackendResources resources;
    private final Iterable<LuceneWork> workList;
    private final IndexingMonitor monitor;

    LuceneBackendQueueTask(Iterable<LuceneWork> workList, LuceneBackendResources resources, IndexingMonitor monitor) {
        this.workList = workList;
        this.resources = resources;
        this.monitor = monitor;
        this.modificationLock = resources.getParallelModificationLock();
    }

    @Override
    public void run() {
        this.modificationLock.lock();
        try {
            this.applyUpdates();
        }
        catch (InterruptedException e) {
            log.interruptedWhileWaitingForIndexActivity(this.resources.getIndexName(), e);
            Thread.currentThread().interrupt();
            this.handleException(e);
        }
        catch (Exception e) {
            log.backendError(e);
            this.handleException(e);
        }
        finally {
            this.modificationLock.unlock();
        }
    }

    private void handleException(Exception e) {
        ErrorContextBuilder builder = new ErrorContextBuilder();
        builder.allWorkToBeDone(this.workList);
        builder.errorThatOccurred(e).indexManager(this.resources.getIndexManager());
        this.resources.getErrorHandler().handle(builder.createErrorContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyUpdates() throws InterruptedException, ExecutionException {
        AbstractWorkspaceImpl workspace = this.resources.getWorkspace();
        ErrorContextBuilder errorContextBuilder = new ErrorContextBuilder();
        errorContextBuilder.indexManager(this.resources.getIndexManager());
        errorContextBuilder.allWorkToBeDone(this.workList);
        IndexWriterDelegate delegate = workspace.getIndexWriterDelegate(errorContextBuilder);
        if (delegate == null) {
            log.cannotOpenIndexWriterCausePreviousError();
            return;
        }
        boolean someFailureHappened = true;
        LuceneWork currentOperation = null;
        try {
            Iterator<LuceneWork> iterator = this.workList.iterator();
            while (iterator.hasNext()) {
                LuceneWork luceneWork;
                currentOperation = luceneWork = iterator.next();
                LuceneBackendQueueTask.performWork(luceneWork, this.resources, delegate, this.monitor);
                errorContextBuilder.workCompleted(currentOperation);
            }
            currentOperation = null;
            workspace.optimizerPhase();
            someFailureHappened = false;
        }
        catch (RuntimeException re) {
            errorContextBuilder.errorThatOccurred(re).indexManager(this.resources.getIndexManager());
            if (currentOperation != null) {
                errorContextBuilder.addWorkThatFailed(currentOperation);
            }
            this.resources.getErrorHandler().handle(errorContextBuilder.createErrorContext());
        }
        finally {
            workspace.afterTransactionApplied(someFailureHappened, false);
        }
    }

    static void performWork(LuceneWork work, LuceneBackendResources resources, IndexWriterDelegate delegate, IndexingMonitor monitor) {
        work.acceptIndexWorkVisitor(resources.getWorkVisitor(), null).performWork(work, delegate, monitor);
    }
}

