/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.jaxrs;

import io.smallrye.jwt.auth.cdi.SmallRyeJWTAuthCDIExtension;
import io.smallrye.jwt.auth.jaxrs.JWTAuthenticationFilter;
import io.smallrye.jwt.auth.jaxrs.JWTAuthorizationFilterRegistrar;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import org.eclipse.microprofile.auth.LoginConfig;
import org.jboss.logging.Logger;

public class SmallRyeJWTAuthJaxRsFeature
implements Feature {
    private static Logger logger = Logger.getLogger(SmallRyeJWTAuthJaxRsFeature.class);
    @Context
    private Application restApplication;

    public boolean configure(FeatureContext context) {
        boolean enabled = this.mpJwtEnabled();
        if (enabled) {
            context.register(JWTAuthorizationFilterRegistrar.class);
            if (!SmallRyeJWTAuthCDIExtension.isHttpAuthMechanismEnabled()) {
                context.register(JWTAuthenticationFilter.class);
                logger.debugf("EE Security is not in use, %s has been registered", (Object)JWTAuthenticationFilter.class.getSimpleName());
            }
            logger.debugf("MP-JWT LoginConfig present, %s is enabled", (Object)this.getClass().getSimpleName());
        } else {
            logger.infof("LoginConfig not found on Application class, %s will not be enabled", (Object)this.getClass().getSimpleName());
        }
        return enabled;
    }

    boolean mpJwtEnabled() {
        Class<?> applicationClass;
        boolean enabled = false;
        if (this.restApplication != null && (applicationClass = this.restApplication.getClass()).isAnnotationPresent(LoginConfig.class)) {
            LoginConfig config = applicationClass.getAnnotation(LoginConfig.class);
            enabled = "MP-JWT".equals(config.authMethod());
        }
        return enabled;
    }
}

