/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz.jacc;

import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.authz.jacc.SecurityActions;

public class DelegatingPolicyContextHandler
implements PolicyContextHandler {
    private final String key;
    private final PolicyContextHandler preferred;
    private final PolicyContextHandler fallBack;

    public DelegatingPolicyContextHandler(String key, PolicyContextHandler preferred, PolicyContextHandler fallBack) {
        this.key = Assert.checkNotNullParam("key", key);
        this.preferred = Assert.checkNotNullParam("preferred", preferred);
        this.fallBack = Assert.checkNotNullParam("fallBack", fallBack);
    }

    public boolean supports(String key) throws PolicyContextException {
        return this.preferred.supports(key);
    }

    public String[] getKeys() throws PolicyContextException {
        return new String[]{this.key};
    }

    public Object getContext(String key, Object data) throws PolicyContextException {
        return DelegatingPolicyContextHandler.getSecurityIdentity() != null ? this.preferred.getContext(key, data) : this.fallBack.getContext(key, data);
    }

    private static SecurityIdentity getSecurityIdentity() {
        SecurityDomain securityDomain = SecurityActions.doPrivileged(SecurityDomain::getCurrent);
        if (securityDomain != null) {
            return securityDomain.getCurrentSecurityIdentity();
        }
        return null;
    }
}

