/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.operators.multi.MultiCombine;
import java.util.ArrayList;
import java.util.Arrays;
import org.reactivestreams.Publisher;

public class MultiMerge {
    private final boolean collectFailures;
    private final int requests;
    private final int concurrency;

    MultiMerge(boolean collectFailures, int requests, int concurrency) {
        this.collectFailures = collectFailures;
        this.requests = requests;
        this.concurrency = concurrency;
    }

    @SafeVarargs
    public final <T> Multi<T> streams(Publisher<T> ... publishers) {
        return MultiCombine.merge(Arrays.asList(publishers), this.collectFailures, this.requests, this.concurrency);
    }

    public <T> Multi<T> streams(Iterable<Publisher<T>> iterable) {
        ArrayList list = new ArrayList();
        iterable.forEach(list::add);
        return MultiCombine.merge(list, this.collectFailures, this.requests, this.concurrency);
    }

    public MultiMerge collectFailures() {
        return new MultiMerge(true, this.requests, this.concurrency);
    }

    public MultiMerge withRequests(int requests) {
        return new MultiMerge(this.collectFailures, requests, this.concurrency);
    }

    public MultiMerge withConcurrency(int concurrency) {
        return new MultiMerge(this.collectFailures, this.requests, concurrency);
    }
}

