/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.http;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MultiHelper;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.mutiny.core.MultiMap;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.core.http.HttpClientRequest;
import io.vertx.mutiny.core.http.HttpFrame;
import io.vertx.mutiny.core.net.NetSocket;
import io.vertx.mutiny.core.streams.Pipe;
import io.vertx.mutiny.core.streams.ReadStream;
import io.vertx.mutiny.core.streams.WriteStream;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

@MutinyGen(value=io.vertx.core.http.HttpClientResponse.class)
public class HttpClientResponse
implements ReadStream<Buffer> {
    public static final TypeArg<HttpClientResponse> __TYPE_ARG = new TypeArg(obj -> new HttpClientResponse((io.vertx.core.http.HttpClientResponse)obj), HttpClientResponse::getDelegate);
    private final io.vertx.core.http.HttpClientResponse delegate;
    static final TypeArg<Buffer> TYPE_ARG_0 = new TypeArg(o1 -> Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
    private NetSocket cached_0;
    private MultiMap cached_1;
    private MultiMap cached_2;
    private List<String> cached_3;
    private HttpClientRequest cached_4;
    private Multi<Buffer> multi;

    public HttpClientResponse(io.vertx.core.http.HttpClientResponse delegate) {
        this.delegate = delegate;
    }

    public HttpClientResponse(Object delegate) {
        this.delegate = (io.vertx.core.http.HttpClientResponse)delegate;
    }

    HttpClientResponse() {
        this.delegate = null;
    }

    public io.vertx.core.http.HttpClientResponse getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpClientResponse that = (HttpClientResponse)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public Pipe<Buffer> pipe() {
        Pipe<Buffer> ret = Pipe.newInstance(this.delegate.pipe(), TYPE_ARG_0);
        return ret;
    }

    @Override
    public Uni<Void> pipeTo(WriteStream<Buffer> dst) {
        return AsyncResultUni.toUni(handler -> this.delegate.pipeTo(dst.getDelegate(), handler));
    }

    @Override
    public Void pipeToAndAwait(WriteStream<Buffer> dst) {
        return (Void)this.pipeTo(dst).await().indefinitely();
    }

    @Override
    public void pipeToAndForget(WriteStream<Buffer> dst) {
        this.pipeTo(dst).subscribe().with(UniHelper.NOOP);
    }

    @Fluent
    public HttpClientResponse fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    @Fluent
    public HttpClientResponse resume() {
        this.delegate.resume();
        return this;
    }

    @Fluent
    private HttpClientResponse __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public HttpClientResponse exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler(handler != null ? handler::accept : null);
    }

    @Fluent
    private HttpClientResponse __handler(final Handler<Buffer> handler) {
        this.delegate.handler((Handler)new Handler<io.vertx.core.buffer.Buffer>(){

            public void handle(io.vertx.core.buffer.Buffer event) {
                handler.handle((Object)Buffer.newInstance(event));
            }
        });
        return this;
    }

    public HttpClientResponse handler(Consumer<Buffer> handler) {
        return this.__handler(handler != null ? handler::accept : null);
    }

    @Fluent
    public HttpClientResponse pause() {
        this.delegate.pause();
        return this;
    }

    @Fluent
    private HttpClientResponse __endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public HttpClientResponse endHandler(Runnable endHandler) {
        return this.__endHandler((Handler<Void>)((Handler)ignored -> endHandler.run()));
    }

    public NetSocket netSocket() {
        NetSocket ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = NetSocket.newInstance(this.delegate.netSocket());
        return ret;
    }

    public HttpVersion version() {
        HttpVersion ret = this.delegate.version();
        return ret;
    }

    public int statusCode() {
        int ret = this.delegate.statusCode();
        return ret;
    }

    public String statusMessage() {
        String ret = this.delegate.statusMessage();
        return ret;
    }

    public MultiMap headers() {
        MultiMap ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    public String getHeader(String headerName) {
        String ret = this.delegate.getHeader(headerName);
        return ret;
    }

    public String getTrailer(String trailerName) {
        String ret = this.delegate.getTrailer(trailerName);
        return ret;
    }

    public MultiMap trailers() {
        MultiMap ret;
        if (this.cached_2 != null) {
            return this.cached_2;
        }
        this.cached_2 = ret = MultiMap.newInstance(this.delegate.trailers());
        return ret;
    }

    public List<String> cookies() {
        List ret;
        if (this.cached_3 != null) {
            return this.cached_3;
        }
        this.cached_3 = ret = this.delegate.cookies();
        return ret;
    }

    @Fluent
    private HttpClientResponse __bodyHandler(final Handler<Buffer> bodyHandler) {
        this.delegate.bodyHandler((Handler)new Handler<io.vertx.core.buffer.Buffer>(){

            public void handle(io.vertx.core.buffer.Buffer event) {
                bodyHandler.handle((Object)Buffer.newInstance(event));
            }
        });
        return this;
    }

    public HttpClientResponse bodyHandler(Consumer<Buffer> bodyHandler) {
        return this.__bodyHandler(bodyHandler != null ? bodyHandler::accept : null);
    }

    public Uni<Buffer> body() {
        return AsyncResultUni.toUni(handler -> this.delegate.body((Handler)new Handler<AsyncResult<io.vertx.core.buffer.Buffer>>(){

            public void handle(AsyncResult<io.vertx.core.buffer.Buffer> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Buffer.newInstance((io.vertx.core.buffer.Buffer)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Buffer bodyAndAwait() {
        return (Buffer)this.body().await().indefinitely();
    }

    @Fluent
    public HttpClientResponse bodyAndForget() {
        this.body().subscribe().with(UniHelper.NOOP);
        return this;
    }

    public Uni<Void> end() {
        return AsyncResultUni.toUni(handler -> this.delegate.end(handler));
    }

    public Void endAndAwait() {
        return (Void)this.end().await().indefinitely();
    }

    public void endAndForget() {
        this.end().subscribe().with(UniHelper.NOOP);
    }

    @Fluent
    private HttpClientResponse __customFrameHandler(final Handler<HttpFrame> handler) {
        this.delegate.customFrameHandler((Handler)new Handler<io.vertx.core.http.HttpFrame>(){

            public void handle(io.vertx.core.http.HttpFrame event) {
                handler.handle((Object)HttpFrame.newInstance(event));
            }
        });
        return this;
    }

    public HttpClientResponse customFrameHandler(Consumer<HttpFrame> handler) {
        return this.__customFrameHandler(handler != null ? handler::accept : null);
    }

    public HttpClientRequest request() {
        HttpClientRequest ret;
        if (this.cached_4 != null) {
            return this.cached_4;
        }
        this.cached_4 = ret = HttpClientRequest.newInstance(this.delegate.request());
        return ret;
    }

    @Fluent
    private HttpClientResponse __streamPriorityHandler(Handler<StreamPriority> handler) {
        this.delegate.streamPriorityHandler(handler);
        return this;
    }

    public HttpClientResponse streamPriorityHandler(Consumer<StreamPriority> handler) {
        return this.__streamPriorityHandler(handler != null ? handler::accept : null);
    }

    public String getHeader(CharSequence headerName) {
        String ret = this.delegate.getHeader(headerName);
        return ret;
    }

    @Override
    public synchronized Multi<Buffer> toMulti() {
        if (this.multi == null) {
            Function<io.vertx.core.buffer.Buffer, Buffer> conv = Buffer::newInstance;
            this.multi = MultiHelper.toMulti((io.vertx.core.streams.ReadStream)this.delegate, conv);
        }
        return this.multi;
    }

    public Iterable<Buffer> toBlockingIterable() {
        return this.toMulti().subscribe().asIterable();
    }

    public Stream<Buffer> toBlockingStream() {
        return this.toMulti().subscribe().asStream();
    }

    public static HttpClientResponse newInstance(io.vertx.core.http.HttpClientResponse arg) {
        return arg != null ? new HttpClientResponse(arg) : null;
    }
}

