/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.io.InvalidClassException;
import org.infinispan.protostream.impl.WireFormat;
import org.wildfly.clustering.marshalling.protostream.ClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.Field;
import org.wildfly.clustering.marshalling.protostream.FieldMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.ScalarClass;
import org.wildfly.security.manager.WildFlySecurityManager;

public class LoadedClassField
implements Field<Class<?>>,
FieldMarshaller<Class<?>> {
    private final ClassLoaderMarshaller loaderMarshaller;
    private final int index;
    private final int loaderIndex;

    public LoadedClassField(ClassLoaderMarshaller loaderMarshaller, int index) {
        this.loaderMarshaller = loaderMarshaller;
        this.index = index;
        this.loaderIndex = index + 1;
    }

    @Override
    public FieldMarshaller<Class<?>> getMarshaller() {
        return this;
    }

    @Override
    public Class<?> readFrom(ProtoStreamReader reader) throws IOException {
        String className = reader.readString();
        ClassLoader loader = (ClassLoader)this.loaderMarshaller.getBuilder();
        boolean reading = true;
        while (reading) {
            int tag = reader.readTag();
            int index = WireFormat.getTagFieldNumber((int)tag);
            if (index >= this.loaderIndex && index < this.loaderIndex + this.loaderMarshaller.getFields()) {
                loader = this.loaderMarshaller.readField(reader, index, loader);
                continue;
            }
            reading = tag != 0 && reader.skipField(tag);
        }
        try {
            return loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            InvalidClassException exception = new InvalidClassException(e.getLocalizedMessage());
            exception.initCause(e);
            throw exception;
        }
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, Class<?> targetClass) throws IOException {
        writer.writeStringNoTag(targetClass.getName());
        this.loaderMarshaller.writeFields(writer, this.loaderIndex, WildFlySecurityManager.getClassLoaderPrivileged(targetClass));
    }

    @Override
    public Class<? extends Class<?>> getJavaClass() {
        return ScalarClass.ANY.getJavaClass();
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public int getWireType() {
        return 2;
    }
}

