/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core;

import io.smallrye.faulttolerance.core.InvocationContextEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;

public final class InvocationContext<V>
implements Callable<V> {
    private final Callable<V> delegate;
    private final ConcurrentMap<Class<?>, Object> data = new ConcurrentHashMap();
    private final ConcurrentMap<Class<? extends InvocationContextEvent>, Collection<Consumer<? extends InvocationContextEvent>>> eventHandlers = new ConcurrentHashMap<Class<? extends InvocationContextEvent>, Collection<Consumer<? extends InvocationContextEvent>>>();

    public InvocationContext(Callable<V> delegate) {
        this.delegate = delegate;
    }

    @Override
    public V call() throws Exception {
        return this.delegate.call();
    }

    public <T> void set(Class<T> clazz, T object) {
        this.data.put(clazz, object);
    }

    public <T> T get(Class<T> clazz) {
        return clazz.cast(this.data.get(clazz));
    }

    public <E extends InvocationContextEvent> void registerEventHandler(Class<E> eventType, Consumer<E> handler) {
        this.eventHandlers.computeIfAbsent(eventType, ignored -> new ConcurrentLinkedQueue()).add(handler);
    }

    public <E extends InvocationContextEvent> void fireEvent(E event) {
        ((Collection)this.eventHandlers.getOrDefault(event.getClass(), Collections.emptySet())).forEach(c -> {
            Consumer consumer = c;
            consumer.accept(event);
        });
    }
}

