/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.handlers.PathHandler;
import java.util.Arrays;
import java.util.Collection;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ServiceRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.DynamicNameMappers;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.HttpInvokerHostService;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.UndertowRootDefinition;
import org.wildfly.security.auth.server.HttpAuthenticationFactory;

public class HttpInvokerDefinition
extends PersistentResourceDefinition {
    static final RuntimeCapability<Void> HTTP_INVOKER_HOST_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.undertow.http-invoker.host", (boolean)true, Void.class).setDynamicNameMapper(DynamicNameMappers.PARENT).addRequirements(new String[]{"org.wildfly.undertow.http-invoker"}).build();
    static final SimpleAttributeDefinition HTTP_AUTHENTICATION_FACTORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("http-authentication-factory", ModelType.STRING, true).setValidator((ParameterValidator)new StringLengthValidator(1, true))).setRestartAllServices()).setCapabilityReference("org.wildfly.security.http-authentication-factory")).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.AUTHENTICATION_FACTORY_REF)).setAlternatives(new String[]{"security-realm"})).build();
    protected static final SimpleAttributeDefinition SECURITY_REALM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-realm", ModelType.STRING, true).setRestartAllServices()).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false))).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SECURITY_REALM_REF)).setAlternatives(new String[]{"http-authentication-factory"})).build();
    protected static final SimpleAttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("path", ModelType.STRING, true).setValidator((ParameterValidator)new StringLengthValidator(1))).setDefaultValue(new ModelNode("wildfly-services"))).setRestartAllServices()).build();
    static final Collection<AttributeDefinition> ATTRIBUTES = Arrays.asList(PATH, HTTP_AUTHENTICATION_FACTORY, SECURITY_REALM);
    static final HttpInvokerDefinition INSTANCE = new HttpInvokerDefinition();

    private HttpInvokerDefinition() {
        super(new PersistentResourceDefinition.Parameters(UndertowExtension.PATH_HTTP_INVOKER, (ResourceDescriptionResolver)UndertowExtension.getResolver("http-invoker")).setAddHandler((OperationStepHandler)new HttpInvokerAdd()).setRemoveHandler((OperationStepHandler)new HttpInvokerRemove()).setCapabilities(new RuntimeCapability[]{HTTP_INVOKER_HOST_CAPABILITY}));
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }

    private static final class HttpInvokerRemove
    extends ServiceRemoveStepHandler {
        HttpInvokerRemove() {
            super((AbstractAddStepHandler)new HttpInvokerAdd());
        }

        protected ServiceName serviceName(String name, PathAddress address) {
            return HTTP_INVOKER_HOST_CAPABILITY.getCapabilityServiceName(address);
        }
    }

    private static final class HttpInvokerAdd
    extends AbstractAddStepHandler {
        HttpInvokerAdd() {
            super(ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            PathAddress address = context.getCurrentAddress();
            PathAddress hostAddress = address.getParent();
            PathAddress serverAddress = hostAddress.getParent();
            String path = PATH.resolveModelAttribute(context, model).asString();
            String httpAuthenticationFactory = null;
            String securityRealmString = null;
            ModelNode authFactory = HTTP_AUTHENTICATION_FACTORY.resolveModelAttribute(context, model);
            ModelNode securityRealm = SECURITY_REALM.resolveModelAttribute(context, model);
            if (authFactory.isDefined()) {
                httpAuthenticationFactory = authFactory.asString();
            } else if (securityRealm.isDefined()) {
                securityRealmString = securityRealm.asString();
            }
            HttpInvokerHostService service = new HttpInvokerHostService(path);
            String serverName = serverAddress.getLastElement().getValue();
            String hostName = hostAddress.getLastElement().getValue();
            CapabilityServiceBuilder builder = context.getCapabilityServiceTarget().addCapability(HTTP_INVOKER_HOST_CAPABILITY).setInstance((Service)service).addCapabilityRequirement(UndertowRootDefinition.HTTP_INVOKER_RUNTIME_CAPABILITY.getName(), PathHandler.class, service.getRemoteHttpInvokerServiceInjectedValue()).addCapabilityRequirement("org.wildfly.undertow.host", Host.class, service.getHost(), new String[]{serverName, hostName});
            if (httpAuthenticationFactory != null) {
                builder.addCapabilityRequirement("org.wildfly.security.http-authentication-factory", HttpAuthenticationFactory.class, service.getHttpAuthenticationFactoryInjectedValue(), new String[]{httpAuthenticationFactory});
            } else if (securityRealmString != null) {
                ServiceName realmServiceName = SecurityRealm.ServiceUtil.createServiceName((String)securityRealmString);
                builder.addDependency(realmServiceName, SecurityRealm.class, service.getRealmService());
            }
            builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
    }
}

