/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.time;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.infinispan.protostream.impl.WireFormat;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.time.LocalDateMarshaller;
import org.wildfly.clustering.marshalling.protostream.time.LocalTimeMarshaller;
import org.wildfly.clustering.marshalling.protostream.time.ZoneOffsetMarshaller;

public class OffsetDateTimeMarshaller
implements ProtoStreamMarshaller<OffsetDateTime> {
    private static final int DATE_INDEX = 1;
    private static final int TIME_INDEX = 1 + LocalDateMarshaller.INSTANCE.getFields();
    private static final int OFFSET_INDEX = TIME_INDEX + LocalTimeMarshaller.INSTANCE.getFields();

    @Override
    public OffsetDateTime readFrom(ProtoStreamReader reader) throws IOException {
        LocalDate date = LocalDateMarshaller.INSTANCE.getBuilder();
        LocalTime time = LocalTimeMarshaller.INSTANCE.getBuilder();
        ZoneOffset offset = ZoneOffsetMarshaller.INSTANCE.getBuilder();
        boolean reading = true;
        while (reading) {
            int tag = reader.readTag();
            int index = WireFormat.getTagFieldNumber((int)tag);
            if (index >= 1 && index < TIME_INDEX) {
                date = LocalDateMarshaller.INSTANCE.readField(reader, index - 1, date);
                continue;
            }
            if (index >= TIME_INDEX && index < OFFSET_INDEX) {
                time = LocalTimeMarshaller.INSTANCE.readField(reader, index - TIME_INDEX, time);
                continue;
            }
            if (index >= OFFSET_INDEX && index < OFFSET_INDEX + ZoneOffsetMarshaller.INSTANCE.getFields()) {
                offset = ZoneOffsetMarshaller.INSTANCE.readField(reader, index - OFFSET_INDEX, offset);
                continue;
            }
            reading = tag != 0 && reader.skipField(tag);
        }
        return OffsetDateTime.of(date, time, offset);
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, OffsetDateTime value) throws IOException {
        LocalDateMarshaller.INSTANCE.writeFields(writer, 1, value.toLocalDate());
        LocalTimeMarshaller.INSTANCE.writeFields(writer, TIME_INDEX, value.toLocalTime());
        ZoneOffsetMarshaller.INSTANCE.writeFields(writer, OFFSET_INDEX, value.getOffset());
    }

    @Override
    public Class<? extends OffsetDateTime> getJavaClass() {
        return OffsetDateTime.class;
    }
}

