/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.api.metadata.common;

import java.util.HashMap;
import java.util.Map;

public enum FlushStrategy {
    UNKNOWN(null),
    FAILING_CONNECTION_ONLY("FailingConnectionOnly"),
    INVALID_IDLE_CONNECTIONS("InvalidIdleConnections"),
    IDLE_CONNECTIONS("IdleConnections"),
    GRACEFULLY("Gracefully"),
    ENTIRE_POOL("EntirePool"),
    ALL_INVALID_IDLE_CONNECTIONS("AllInvalidIdleConnections"),
    ALL_IDLE_CONNECTIONS("AllIdleConnections"),
    ALL_GRACEFULLY("AllGracefully"),
    ALL_CONNECTIONS("AllConnections");

    private final String name;
    private static final Map<String, FlushStrategy> MAP;

    private FlushStrategy(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static FlushStrategy forName(String name) {
        FlushStrategy element = MAP.get(name);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, FlushStrategy> map = new HashMap<String, FlushStrategy>();
        for (FlushStrategy element : FlushStrategy.values()) {
            String name = element.getName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

