/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.acl;

import org.jboss.security.acl.BasicACLPermission;
import org.jboss.security.acl.BitMaskPermission;

public class CompositeACLPermission
implements BitMaskPermission {
    private int mask = 0;

    public CompositeACLPermission(int mask) {
        this.mask = mask;
    }

    public CompositeACLPermission(BasicACLPermission ... permissions) {
        for (BasicACLPermission basicPermission : permissions) {
            this.mask |= basicPermission.getMaskValue();
        }
    }

    @Override
    public int getMaskValue() {
        return this.mask;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BitMaskPermission) {
            return this.mask == ((BitMaskPermission)obj).getMaskValue();
        }
        return false;
    }

    public int hashCode() {
        return this.mask;
    }

    public String toString() {
        if (this.mask == 0) {
            return "NO PERMISSION";
        }
        StringBuffer buffer = new StringBuffer();
        for (BasicACLPermission permission : BasicACLPermission.values()) {
            if ((permission.getMaskValue() & this.mask) == 0) continue;
            buffer.append(permission.toString() + ",");
        }
        return buffer.substring(0, buffer.lastIndexOf(","));
    }

    public String toBinaryString() {
        return Integer.toBinaryString(this.mask);
    }
}

