/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso;

import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.logging.Logger;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.BatchContext;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.web.sso.SSO;
import org.wildfly.clustering.web.sso.Sessions;
import org.wildfly.clustering.web.undertow.sso.InvalidatableSingleSignOn;
import org.wildfly.clustering.web.undertow.sso.SessionManagerRegistry;

public class DistributableSingleSignOn
implements InvalidatableSingleSignOn {
    static final Logger LOGGER = Logger.getLogger(DistributableSingleSignOn.class);
    private final SSO<AuthenticatedSessionManager.AuthenticatedSession, String, String, Void> sso;
    private final SessionManagerRegistry registry;
    private final Batcher<Batch> batcher;
    private final Batch batch;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public DistributableSingleSignOn(SSO<AuthenticatedSessionManager.AuthenticatedSession, String, String, Void> sso, SessionManagerRegistry registry, Batcher<Batch> batcher, Batch batch) {
        this.sso = sso;
        this.registry = registry;
        this.batcher = batcher;
        this.batch = batch;
    }

    public String getId() {
        return this.sso.getId();
    }

    public Account getAccount() {
        try (BatchContext context = this.batcher.resumeBatch(this.batch);){
            Account account = ((AuthenticatedSessionManager.AuthenticatedSession)this.sso.getAuthentication()).getAccount();
            return account;
        }
    }

    public String getMechanismName() {
        try (BatchContext context = this.batcher.resumeBatch(this.batch);){
            String string = ((AuthenticatedSessionManager.AuthenticatedSession)this.sso.getAuthentication()).getMechanism();
            return string;
        }
    }

    public Iterator<Session> iterator() {
        try (BatchContext context = this.batcher.resumeBatch(this.batch);){
            Sessions sessions = this.sso.getSessions();
            Set deployments = sessions.getDeployments();
            ArrayList<InvalidatableSession> result = new ArrayList<InvalidatableSession>(deployments.size());
            for (String deployment : sessions.getDeployments()) {
                SessionManager manager;
                String sessionId = (String)sessions.getSession((Object)deployment);
                if (sessionId == null || (manager = this.registry.getSessionManager(deployment)) == null) continue;
                result.add(new InvalidatableSession(manager, sessionId));
            }
            Iterator<Session> iterator = result.iterator();
            return iterator;
        }
    }

    public boolean contains(Session session) {
        try (BatchContext context = this.batcher.resumeBatch(this.batch);){
            boolean bl = this.sso.getSessions().getDeployments().contains(session.getSessionManager().getDeploymentName());
            return bl;
        }
    }

    public void add(Session session) {
        try (BatchContext context = this.batcher.resumeBatch(this.batch);){
            if (LOGGER.isTraceEnabled()) {
                LOGGER.tracef("Adding Session ID %s to SSO session %s.", (Object)session.getId(), (Object)this.sso.getId());
            }
            this.sso.getSessions().addSession((Object)session.getSessionManager().getDeploymentName(), (Object)session.getId());
        }
    }

    public void remove(Session session) {
        try (BatchContext context = this.batcher.resumeBatch(this.batch);){
            if (LOGGER.isTraceEnabled()) {
                LOGGER.tracef("Removing SSO ID %s from deployment %s.", (Object)this.sso.getId(), (Object)session.getSessionManager().getDeploymentName());
            }
            this.sso.getSessions().removeSession((Object)session.getSessionManager().getDeploymentName());
        }
    }

    public Session getSession(SessionManager manager) {
        try (BatchContext context = this.batcher.resumeBatch(this.batch);){
            String sessionId = (String)this.sso.getSessions().getSession((Object)manager.getDeploymentName());
            InvalidatableSession invalidatableSession = sessionId != null ? new InvalidatableSession(manager, sessionId) : null;
            return invalidatableSession;
        }
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            try (BatchContext context = this.batcher.resumeBatch(this.batch);){
                this.batch.close();
            }
        }
    }

    @Override
    public void invalidate() {
        try (BatchContext context = this.closed.compareAndSet(false, true) ? this.batcher.resumeBatch(this.batch) : null;
             Batch batch = context != null ? this.batch : this.batcher.createBatch();){
            if (LOGGER.isTraceEnabled()) {
                LOGGER.tracef("Invalidating SSO ID %s.", (Object)this.sso.getId());
            }
            this.sso.invalidate();
        }
    }

    private static class SimpleSessionConfig
    implements SessionConfig {
        private final String id;

        SimpleSessionConfig(String id) {
            this.id = id;
        }

        public String findSessionId(HttpServerExchange exchange) {
            return this.id;
        }

        public void setSessionId(HttpServerExchange exchange, String sessionId) {
            throw new UnsupportedOperationException();
        }

        public void clearSession(HttpServerExchange exchange, String sessionId) {
            throw new UnsupportedOperationException();
        }

        public SessionConfig.SessionCookieSource sessionCookieSource(HttpServerExchange exchange) {
            throw new UnsupportedOperationException();
        }

        public String rewriteUrl(String originalUrl, String sessionId) {
            throw new UnsupportedOperationException();
        }
    }

    private static class InvalidatableSession
    implements Session {
        private final SessionManager manager;
        private final String sessionId;

        InvalidatableSession(SessionManager manager, String sessionId) {
            this.manager = manager;
            this.sessionId = sessionId;
        }

        public String getId() {
            return this.sessionId;
        }

        public SessionManager getSessionManager() {
            return this.manager;
        }

        public void invalidate(HttpServerExchange exchange) {
            Session session = this.manager.getSession(exchange, (SessionConfig)new SimpleSessionConfig(this.sessionId));
            if (session != null) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.tracef("Invalidating Session ID %s.", (Object)session.getId());
                }
                session.invalidate(exchange);
            }
        }

        public String changeSessionId(HttpServerExchange exchange, SessionConfig config) {
            throw new UnsupportedOperationException();
        }

        public Object getAttribute(String name) {
            throw new UnsupportedOperationException();
        }

        public Set<String> getAttributeNames() {
            throw new UnsupportedOperationException();
        }

        public long getCreationTime() {
            throw new UnsupportedOperationException();
        }

        public long getLastAccessedTime() {
            throw new UnsupportedOperationException();
        }

        public int getMaxInactiveInterval() {
            throw new UnsupportedOperationException();
        }

        public Object removeAttribute(String name) {
            throw new UnsupportedOperationException();
        }

        public void requestDone(HttpServerExchange exchange) {
            throw new UnsupportedOperationException();
        }

        public Object setAttribute(String name, Object value) {
            throw new UnsupportedOperationException();
        }

        public void setMaxInactiveInterval(int interval) {
            throw new UnsupportedOperationException();
        }
    }
}

