/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.ExceptionSyncInvocationStage;
import org.infinispan.interceptors.InvocationCallback;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.impl.SimpleAsyncInvocationStage;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class QueueAsyncInvocationStage
extends SimpleAsyncInvocationStage
implements BiConsumer<Object, Throwable>,
InvocationCallback {
    private static final Log log = LogFactory.getLog(QueueAsyncInvocationStage.class);
    private static final boolean trace = log.isTraceEnabled();
    private final InvocationContext ctx;
    private final VisitableCommand command;
    static final int QUEUE_INITIAL_CAPACITY = 8;
    private InvocationCallback[] elements = null;
    private byte mask;
    private byte head;
    private byte tail;
    private boolean frozen;

    public QueueAsyncInvocationStage(InvocationContext ctx, VisitableCommand command, CompletableFuture<?> valueFuture, InvocationCallback function) {
        super(new CompletableFuture());
        this.ctx = ctx;
        this.command = command;
        this.queueAdd(function);
        if (CompletionStages.isCompletedSuccessfully(valueFuture)) {
            this.accept(valueFuture.join(), null);
        } else {
            valueFuture.whenComplete((BiConsumer)this);
        }
    }

    public Object addCallback(InvocationContext ctx, VisitableCommand command, InvocationCallback function) {
        if (ctx != this.ctx || command != this.command) {
            return new SimpleAsyncInvocationStage(this.future).addCallback(ctx, command, function);
        }
        if (this.queueAdd(function)) {
            return this;
        }
        return this.invokeDirectly(ctx, command, function);
    }

    private Object invokeDirectly(InvocationContext ctx, VisitableCommand command, InvocationCallback function) {
        Throwable throwable;
        Object rv;
        try {
            rv = this.future.join();
            throwable = null;
        }
        catch (Throwable t) {
            rv = null;
            throwable = CompletableFutures.extractException(t);
        }
        try {
            return function.apply(ctx, command, rv, throwable);
        }
        catch (Throwable t) {
            return new ExceptionSyncInvocationStage(t);
        }
    }

    @Override
    public void accept(Object rv, Throwable throwable) {
        this.invokeQueuedHandlers(rv, throwable);
    }

    public Object apply(InvocationContext rCtx, VisitableCommand rCommand, Object rv, Throwable throwable) throws Throwable {
        this.invokeQueuedHandlers(rv, throwable);
        if (throwable == null) {
            return rv;
        }
        throw throwable;
    }

    private void invokeQueuedHandlers(Object rv, Throwable throwable) {
        if (trace) {
            log.tracef("Resuming invocation of command %s with %d handlers", this.command, this.queueSize());
        }
        do {
            InvocationCallback function;
            if ((function = this.queuePoll()) == null) {
                if (throwable == null) {
                    this.future.complete(rv);
                } else {
                    this.future.completeExceptionally(throwable);
                }
                return;
            }
            try {
                if (throwable != null) {
                    throwable = CompletableFutures.extractException(throwable);
                }
                rv = function.apply(this.ctx, this.command, rv, throwable);
                throwable = null;
            }
            catch (Throwable t) {
                rv = null;
                throwable = t;
            }
        } while (!(rv instanceof InvocationStage));
        InvocationStage currentStage = (InvocationStage)rv;
        currentStage.addCallback(this.ctx, this.command, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean queueAdd(InvocationCallback element) {
        QueueAsyncInvocationStage queueAsyncInvocationStage = this;
        synchronized (queueAsyncInvocationStage) {
            if (this.frozen) {
                return false;
            }
            if (this.elements == null || this.tail - this.head > this.mask) {
                this.queueExpand();
            }
            this.elements[this.tail & this.mask] = element;
            this.tail = (byte)(this.tail + 1);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InvocationCallback queuePoll() {
        InvocationCallback element;
        QueueAsyncInvocationStage queueAsyncInvocationStage = this;
        synchronized (queueAsyncInvocationStage) {
            if (this.tail != this.head) {
                element = this.elements[this.head & this.mask];
                this.head = (byte)(this.head + 1);
            } else {
                element = null;
                this.frozen = true;
            }
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int queueSize() {
        QueueAsyncInvocationStage queueAsyncInvocationStage = this;
        synchronized (queueAsyncInvocationStage) {
            return this.tail - this.head;
        }
    }

    private void queueExpand() {
        if (this.elements == null) {
            this.elements = new InvocationCallback[8];
            this.mask = (byte)7;
            return;
        }
        InvocationCallback[] oldElements = this.elements;
        int oldCapacity = oldElements.length;
        byte oldMask = this.mask;
        byte oldHead = this.head;
        byte oldTail = this.tail;
        int maskedHead = oldHead & oldMask;
        int maskedTail = oldTail & oldMask;
        int oldSize = this.tail - this.head;
        if (oldSize != oldCapacity) {
            throw new IllegalStateException("Queue should be expanded only when full");
        }
        int newSize = oldCapacity * 2;
        int newMask = newSize - 1;
        this.elements = new InvocationCallback[newSize];
        this.mask = (byte)newMask;
        this.head = 0;
        this.tail = (byte)(oldTail - oldHead);
        if (maskedHead < maskedTail) {
            System.arraycopy(oldElements, maskedHead, this.elements, 0, oldSize);
        } else {
            System.arraycopy(oldElements, maskedHead, this.elements, 0, oldCapacity - maskedHead);
            System.arraycopy(oldElements, 0, this.elements, oldCapacity - maskedHead, maskedTail);
        }
    }

    @Override
    public String toString() {
        return "SimpleAsyncInvocationStage(" + this.queueSize() + "handlers, " + this.future + ')';
    }
}

