/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.mirror;

import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.mirror.MirrorController;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorControllerSource;

public class AMQPMirrorControllerAggregation
implements MirrorController,
ActiveMQComponent {
    List<AMQPMirrorControllerSource> partitions = new ArrayList<AMQPMirrorControllerSource>();

    public void addPartition(AMQPMirrorControllerSource partition) {
        this.partitions.add(partition);
    }

    public void removeParition(AMQPMirrorControllerSource partition) {
        this.partitions.remove(partition);
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public boolean isStarted() {
        return false;
    }

    public List<AMQPMirrorControllerSource> getPartitions() {
        return this.partitions;
    }

    public void addAddress(AddressInfo addressInfo) throws Exception {
        for (MirrorController mirrorController : this.partitions) {
            mirrorController.addAddress(addressInfo);
        }
    }

    public void deleteAddress(AddressInfo addressInfo) throws Exception {
        for (MirrorController mirrorController : this.partitions) {
            mirrorController.deleteAddress(addressInfo);
        }
    }

    public void createQueue(QueueConfiguration queueConfiguration) throws Exception {
        for (MirrorController mirrorController : this.partitions) {
            mirrorController.createQueue(queueConfiguration);
        }
    }

    public void deleteQueue(SimpleString addressName, SimpleString queueName) throws Exception {
        for (MirrorController mirrorController : this.partitions) {
            mirrorController.deleteQueue(addressName, queueName);
        }
    }

    public void sendMessage(Message message, RoutingContext context, List<MessageReference> refs) {
        for (MirrorController mirrorController : this.partitions) {
            mirrorController.sendMessage(message, context, refs);
        }
    }

    public void postAcknowledge(MessageReference ref, AckReason reason) throws Exception {
        for (MirrorController mirrorController : this.partitions) {
            mirrorController.postAcknowledge(ref, reason);
        }
    }

    public void startAddressScan() throws Exception {
        for (MirrorController mirrorController : this.partitions) {
            mirrorController.startAddressScan();
        }
    }

    public void endAddressScan() throws Exception {
        for (MirrorController mirrorController : this.partitions) {
            mirrorController.endAddressScan();
        }
    }
}

