/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.mirror;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.ToLongFunction;
import java.util.stream.Stream;
import org.apache.activemq.artemis.api.core.ActiveMQAddressDoesNotExistException;
import org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.RoutingContextImpl;
import org.apache.activemq.artemis.core.server.mirror.MirrorController;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessageBrokerAccessor;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorControllerSource;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonAbstractReceiver;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Receiver;
import org.jboss.logging.Logger;

public class AMQPMirrorControllerTarget
extends ProtonAbstractReceiver
implements MirrorController {
    public static final SimpleString INTERNAL_ID_EXTRA_PROPERTY = SimpleString.toSimpleString((String)AMQPMirrorControllerSource.INTERNAL_ID.toString());
    private static final Logger logger = Logger.getLogger(AMQPMirrorControllerTarget.class);
    final ActiveMQServer server;
    final RoutingContextImpl routingContext = new RoutingContextImpl(null);
    Map<SimpleString, Map<SimpleString, QueueConfiguration>> scanAddresses;
    private static ToLongFunction<MessageReference> referenceIDSupplier = source -> {
        Long id = (Long)source.getMessage().getBrokerProperty(INTERNAL_ID_EXTRA_PROPERTY);
        if (id == null) {
            return -1L;
        }
        return id;
    };

    public AMQPMirrorControllerTarget(AMQPSessionCallback sessionSPI, AMQPConnectionContext connection, AMQPSessionContext protonSession, Receiver receiver, ActiveMQServer server) {
        super(sessionSPI, connection, protonSession, receiver);
        this.server = server;
    }

    @Override
    public void flow() {
        this.creditRunnable.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actualDelivery(AMQPMessage message, Delivery delivery, Receiver receiver, Transaction tx) {
        this.incrementSettle();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.server.getIdentity() + "::Received " + (Object)((Object)message)));
        }
        try {
            Object eventType = AMQPMessageBrokerAccessor.getMessageAnnotationProperty(message, AMQPMirrorControllerSource.EVENT_TYPE);
            if (eventType != null) {
                if (eventType.equals(AMQPMirrorControllerSource.ADDRESS_SCAN_START)) {
                    logger.debug((Object)"Starting scan for removed queues");
                    this.startAddressScan();
                } else if (eventType.equals(AMQPMirrorControllerSource.ADDRESS_SCAN_END)) {
                    logger.debug((Object)"Ending scan for removed queues");
                    this.endAddressScan();
                } else if (eventType.equals(AMQPMirrorControllerSource.ADD_ADDRESS)) {
                    AddressInfo addressInfo = this.parseAddress(message);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Adding Address " + addressInfo));
                    }
                    this.addAddress(addressInfo);
                } else if (eventType.equals(AMQPMirrorControllerSource.DELETE_ADDRESS)) {
                    AddressInfo addressInfo = this.parseAddress(message);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Removing Address " + addressInfo));
                    }
                    this.deleteAddress(addressInfo);
                } else if (eventType.equals(AMQPMirrorControllerSource.CREATE_QUEUE)) {
                    QueueConfiguration queueConfiguration = this.parseQueue(message);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Creating queue " + queueConfiguration));
                    }
                    this.createQueue(queueConfiguration);
                } else if (eventType.equals(AMQPMirrorControllerSource.DELETE_QUEUE)) {
                    String address = (String)AMQPMessageBrokerAccessor.getMessageAnnotationProperty(message, AMQPMirrorControllerSource.ADDRESS);
                    String queueName = (String)AMQPMessageBrokerAccessor.getMessageAnnotationProperty(message, AMQPMirrorControllerSource.QUEUE);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Deleting queue " + queueName + " on address " + address));
                    }
                    this.deleteQueue(SimpleString.toSimpleString((String)address), SimpleString.toSimpleString((String)queueName));
                } else if (eventType.equals(AMQPMirrorControllerSource.POST_ACK)) {
                    String address = (String)AMQPMessageBrokerAccessor.getMessageAnnotationProperty(message, AMQPMirrorControllerSource.ADDRESS);
                    String queueName = (String)AMQPMessageBrokerAccessor.getMessageAnnotationProperty(message, AMQPMirrorControllerSource.QUEUE);
                    AmqpValue value = (AmqpValue)message.getBody();
                    Long messageID = (Long)value.getValue();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Post ack address=" + address + " queueName = " + queueName + " messageID=" + messageID));
                    }
                    this.postAcknowledge(address, queueName, messageID);
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Sending message " + (Object)((Object)message)));
                }
                this.sendMessage(message);
            }
        }
        catch (Throwable e) {
            logger.warn((Object)e.getMessage(), e);
        }
        finally {
            delivery.disposition((DeliveryState)Accepted.getInstance());
            this.settle(delivery);
            this.connection.flush();
        }
    }

    @Override
    public void initialize() throws Exception {
        super.initialize();
        Target target = (Target)this.receiver.getRemoteTarget();
        this.receiver.setSenderSettleMode(this.receiver.getRemoteSenderSettleMode());
        this.receiver.setReceiverSettleMode(ReceiverSettleMode.FIRST);
        this.flow();
    }

    private QueueConfiguration parseQueue(AMQPMessage message) throws Exception {
        AmqpValue bodyvalue = (AmqpValue)message.getBody();
        String body = (String)bodyvalue.getValue();
        QueueConfiguration queueConfiguration = QueueConfiguration.fromJSON((String)body);
        return queueConfiguration;
    }

    private AddressInfo parseAddress(AMQPMessage message) throws Exception {
        AmqpValue bodyvalue = (AmqpValue)message.getBody();
        String body = (String)bodyvalue.getValue();
        AddressInfo addressInfo = AddressInfo.fromJSON((String)body);
        return addressInfo;
    }

    public void startAddressScan() throws Exception {
        this.scanAddresses = new HashMap<SimpleString, Map<SimpleString, QueueConfiguration>>();
    }

    public void endAddressScan() throws Exception {
        Map<SimpleString, Map<SimpleString, QueueConfiguration>> scannedAddresses = this.scanAddresses;
        this.scanAddresses = null;
        Stream bindings = this.server.getPostOffice().getAllBindings();
        bindings.forEach(binding -> {
            if (binding instanceof LocalQueueBinding) {
                LocalQueueBinding localQueueBinding = (LocalQueueBinding)binding;
                Map scannedQueues = (Map)scannedAddresses.get(localQueueBinding.getQueue().getAddress());
                if (scannedQueues == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("There's no address " + localQueueBinding.getQueue().getAddress() + " so, removing queue"));
                    }
                    try {
                        this.deleteQueue(localQueueBinding.getQueue().getAddress(), localQueueBinding.getQueue().getName());
                    }
                    catch (Exception e) {
                        logger.warn((Object)e.getMessage(), (Throwable)e);
                    }
                } else {
                    QueueConfiguration queueConfg = (QueueConfiguration)scannedQueues.get(localQueueBinding.getQueue().getName());
                    if (queueConfg == null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("There no queue for " + localQueueBinding.getQueue().getName() + " so, removing queue"));
                        }
                        try {
                            this.deleteQueue(localQueueBinding.getQueue().getAddress(), localQueueBinding.getQueue().getName());
                        }
                        catch (Exception e) {
                            logger.warn((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
        });
    }

    private Map<SimpleString, QueueConfiguration> getQueueScanMap(SimpleString address) {
        Map<SimpleString, QueueConfiguration> queueMap = this.scanAddresses.get(address);
        if (queueMap == null) {
            queueMap = new HashMap<SimpleString, QueueConfiguration>();
            this.scanAddresses.put(address, queueMap);
        }
        return queueMap;
    }

    public void addAddress(AddressInfo addressInfo) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding address " + addressInfo));
        }
        this.server.addAddressInfo(addressInfo);
    }

    public void deleteAddress(AddressInfo addressInfo) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("delete address " + addressInfo));
        }
        try {
            this.server.removeAddressInfo(addressInfo.getName(), null, true);
        }
        catch (ActiveMQAddressDoesNotExistException expected) {
            logger.debug((Object)expected.getMessage(), (Throwable)expected);
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void createQueue(QueueConfiguration queueConfiguration) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding queue " + queueConfiguration));
        }
        this.server.createQueue(queueConfiguration, true);
        if (this.scanAddresses != null) {
            this.getQueueScanMap(queueConfiguration.getAddress()).put(queueConfiguration.getName(), queueConfiguration);
        }
    }

    public void deleteQueue(SimpleString addressName, SimpleString queueName) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("destroy queue " + queueName + " on address = " + addressName));
        }
        try {
            this.server.destroyQueue(queueName);
        }
        catch (ActiveMQNonExistentQueueException expected) {
            logger.debug((Object)("queue " + queueName + " was previously removed"), (Throwable)expected);
        }
    }

    public void postAcknowledge(String address, String queue, long messageID) {
        Queue targetQueue;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("post acking " + address + ", queue = " + queue + ", messageID = " + messageID));
        }
        if ((targetQueue = this.server.locateQueue(queue)) != null) {
            MessageReference reference = targetQueue.removeWithSuppliedID(messageID, referenceIDSupplier);
            if (reference != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Acking reference " + reference));
                }
                try {
                    targetQueue.acknowledge(reference);
                }
                catch (Exception e) {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                }
            } else if (logger.isTraceEnabled()) {
                logger.trace((Object)("There is no reference to ack on " + messageID));
            }
        }
    }

    private void sendMessage(AMQPMessage message) throws Exception {
        if (message.getMessageID() <= 0L) {
            message.setMessageID(this.server.getStorageManager().generateID());
        }
        Long internalID = (Long)AMQPMessageBrokerAccessor.getDeliveryAnnotationProperty(message, AMQPMirrorControllerSource.INTERNAL_ID);
        String internalAddress = (String)AMQPMessageBrokerAccessor.getDeliveryAnnotationProperty(message, AMQPMirrorControllerSource.INTERNAL_DESTINATION);
        if (internalID != null) {
            message.setBrokerProperty(INTERNAL_ID_EXTRA_PROPERTY, internalID);
        }
        if (internalAddress != null) {
            message.setAddress(internalAddress);
        }
        this.routingContext.clear();
        this.server.getPostOffice().route((Message)message, (RoutingContext)this.routingContext, false);
        this.flow();
    }

    public void postAcknowledge(MessageReference ref, AckReason reason) {
    }

    public void sendMessage(Message message, RoutingContext context, List<MessageReference> refs) {
    }
}

