/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet.deployment;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.batch.operations.JobExecutionAlreadyCompleteException;
import javax.batch.operations.JobExecutionIsRunningException;
import javax.batch.operations.JobExecutionNotMostRecentException;
import javax.batch.operations.JobExecutionNotRunningException;
import javax.batch.operations.JobOperator;
import javax.batch.operations.JobRestartException;
import javax.batch.operations.JobSecurityException;
import javax.batch.operations.JobStartException;
import javax.batch.operations.NoSuchJobException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.operations.NoSuchJobInstanceException;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.StepExecution;
import org.jberet.operations.AbstractJobOperator;
import org.jberet.runtime.JobExecutionImpl;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ProcessStateNotifier;
import org.jboss.as.server.suspend.ServerActivity;
import org.jboss.as.server.suspend.ServerActivityCallback;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.batch.jberet.BatchConfiguration;
import org.wildfly.extension.batch.jberet._private.BatchLogger;
import org.wildfly.extension.batch.jberet.deployment.BatchPermission;
import org.wildfly.extension.batch.jberet.deployment.SecurityAwareBatchEnvironment;
import org.wildfly.extension.batch.jberet.deployment.WildFlyJobOperator;
import org.wildfly.extension.batch.jberet.deployment.WildFlyJobXmlResolver;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.manager.WildFlySecurityManager;

public class JobOperatorService
extends AbstractJobOperator
implements WildFlyJobOperator,
JobOperator,
Service<JobOperator> {
    private static final Properties RESTART_PROPS = new Properties();
    private final InjectedValue<BatchConfiguration> batchConfigurationInjector = new InjectedValue();
    private final InjectedValue<SecurityAwareBatchEnvironment> batchEnvironmentInjector = new InjectedValue();
    private final InjectedValue<ExecutorService> executorInjector = new InjectedValue();
    private final InjectedValue<SuspendController> suspendControllerInjector = new InjectedValue();
    private final InjectedValue<ProcessStateNotifier> processStateInjector = new InjectedValue();
    private volatile SecurityAwareBatchEnvironment batchEnvironment;
    private volatile ClassLoader classLoader;
    private final Boolean restartJobsOnResume;
    private final WildFlyJobXmlResolver resolver;
    private final BatchJobServerActivity serverActivity;
    private final String deploymentName;
    private final ThreadLocal<Boolean> permissionsCheckEnabled = ThreadLocal.withInitial(() -> Boolean.TRUE);

    public JobOperatorService(Boolean restartJobsOnResume, String deploymentName, WildFlyJobXmlResolver resolver) {
        this.restartJobsOnResume = restartJobsOnResume;
        this.deploymentName = deploymentName;
        this.resolver = resolver;
        this.serverActivity = new BatchJobServerActivity();
    }

    public void start(StartContext context) throws StartException {
        SecurityAwareBatchEnvironment batchEnvironment = this.batchEnvironment = (SecurityAwareBatchEnvironment)this.batchEnvironmentInjector.getValue();
        this.classLoader = batchEnvironment.getClassLoader();
        ((ProcessStateNotifier)this.processStateInjector.getValue()).addPropertyChangeListener((PropertyChangeListener)this.serverActivity);
        ((SuspendController)this.suspendControllerInjector.getValue()).registerActivity((ServerActivity)this.serverActivity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(StopContext context) {
        ((SuspendController)this.suspendControllerInjector.getValue()).unRegisterActivity((ServerActivity)this.serverActivity);
        ((ProcessStateNotifier)this.processStateInjector.getValue()).removePropertyChangeListener((PropertyChangeListener)this.serverActivity);
        ExecutorService service = (ExecutorService)this.executorInjector.getValue();
        Runnable task = () -> {
            this.serverActivity.stopRunningJobs(false);
            this.batchEnvironment = null;
            this.classLoader = null;
            context.complete();
        };
        try {
            service.execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    public JobOperator getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public SecurityAwareBatchEnvironment getBatchEnvironment() {
        if (this.batchEnvironment == null) {
            throw BatchLogger.LOGGER.jobOperatorServiceStopped();
        }
        return this.batchEnvironment;
    }

    public Set<String> getJobNames() throws JobSecurityException {
        this.checkState();
        HashSet<String> set = new HashSet<String>();
        for (String s : super.getJobNames()) {
            if (!this.resolver.isValidJobName(s)) continue;
            set.add(s);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getJobInstanceCount(String jobName) throws NoSuchJobException, JobSecurityException {
        this.checkState(jobName);
        ClassLoader current = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            int n = super.getJobInstanceCount(jobName);
            return n;
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JobInstance> getJobInstances(String jobName, int start, int count) throws NoSuchJobException, JobSecurityException {
        this.checkState(jobName);
        ClassLoader current = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            List list = super.getJobInstances(jobName, start, count);
            return list;
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getRunningExecutions(String jobName) throws NoSuchJobException, JobSecurityException {
        this.checkState(jobName);
        ClassLoader current = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            List list = super.getRunningExecutions(jobName);
            return list;
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getParameters(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        this.checkState();
        ClassLoader current = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            JobInstance instance = super.getJobInstance(executionId);
            this.validateJob(instance.getJobName());
            Properties properties = super.getParameters(executionId);
            return properties;
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
        }
    }

    public long start(String jobXMLName, Properties jobParameters) throws JobStartException, JobSecurityException {
        this.checkState(null, "start");
        ClassLoader current = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            String jobXml = jobXMLName.endsWith(".xml") ? jobXMLName : jobXMLName + ".xml";
            if (this.resolver.isValidJobXmlName(jobXml)) {
                long l = super.start(jobXml, jobParameters, this.getBatchEnvironment().getCurrentUserName());
                return l;
            }
            throw BatchLogger.LOGGER.couldNotFindJobXml(jobXMLName);
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long restart(long executionId, Properties restartParameters) throws JobExecutionAlreadyCompleteException, NoSuchJobExecutionException, JobExecutionNotMostRecentException, JobRestartException, JobSecurityException {
        this.checkState(null, "restart");
        ClassLoader current = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            JobInstance instance = super.getJobInstance(executionId);
            this.validateJob(instance.getJobName());
            long l = super.restart(executionId, restartParameters, this.getBatchEnvironment().getCurrentUserName());
            return l;
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(long executionId) throws NoSuchJobExecutionException, JobExecutionNotRunningException, JobSecurityException {
        this.checkState(null, "stop");
        ClassLoader current = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            JobInstance instance = super.getJobInstance(executionId);
            this.validateJob(instance.getJobName());
            super.stop(executionId);
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abandon(long executionId) throws NoSuchJobExecutionException, JobExecutionIsRunningException, JobSecurityException {
        this.checkState(null, "abandon");
        ClassLoader current = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            JobInstance instance = super.getJobInstance(executionId);
            this.validateJob(instance.getJobName());
            super.abandon(executionId);
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobInstance getJobInstance(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        this.checkState();
        ClassLoader current = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            JobInstance instance = super.getJobInstance(executionId);
            this.validateJob(instance.getJobName());
            JobInstance jobInstance = super.getJobInstance(executionId);
            return jobInstance;
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JobExecution> getJobExecutions(JobInstance instance) throws NoSuchJobInstanceException, JobSecurityException {
        this.checkState();
        ClassLoader current = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            this.validateJob(instance == null ? null : instance.getJobName());
            List list = super.getJobExecutions(instance);
            return list;
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobExecution getJobExecution(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        this.checkState();
        ClassLoader current = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            JobInstance instance = this.getJobInstance(executionId);
            this.validateJob(instance.getJobName());
            JobExecution jobExecution = super.getJobExecution(executionId);
            return jobExecution;
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StepExecution> getStepExecutions(long jobExecutionId) throws NoSuchJobExecutionException, JobSecurityException {
        this.checkState();
        ClassLoader current = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            JobInstance instance = super.getJobInstance(jobExecutionId);
            this.validateJob(instance.getJobName());
            List list = super.getStepExecutions(jobExecutionId);
            return list;
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
        }
    }

    @Override
    public Collection<String> getJobXmlNames() {
        return this.resolver.getJobXmlNames(this.classLoader);
    }

    @Override
    public Collection<String> getJobXmlNames(String jobName) {
        return this.resolver.getJobXmlNames(jobName);
    }

    @Override
    public Set<String> getAllJobNames() {
        return this.resolver.getJobNames();
    }

    public InjectedValue<BatchConfiguration> getBatchConfigurationInjector() {
        return this.batchConfigurationInjector;
    }

    public Injector<SecurityAwareBatchEnvironment> getBatchEnvironmentInjector() {
        return this.batchEnvironmentInjector;
    }

    public Injector<ExecutorService> getExecutorServiceInjector() {
        return this.executorInjector;
    }

    public InjectedValue<SuspendController> getSuspendControllerInjector() {
        return this.suspendControllerInjector;
    }

    Injector<ProcessStateNotifier> getProcessStateInjector() {
        return this.processStateInjector;
    }

    private void checkState() {
        this.checkState(null);
    }

    private void checkState(String jobName) {
        this.checkState(jobName, "read");
    }

    private void checkState(String jobName, String targetName) {
        if (this.batchEnvironment == null || this.classLoader == null) {
            throw BatchLogger.LOGGER.jobOperatorServiceStopped();
        }
        this.checkPermission(targetName);
        if (jobName != null) {
            this.validateJob(jobName);
        }
    }

    private void checkPermission(String targetName) {
        BatchPermission permission;
        SecurityAwareBatchEnvironment environment;
        SecurityIdentity identity;
        if (this.permissionsCheckEnabled.get().booleanValue() && (identity = (environment = this.getBatchEnvironment()).getIdentity()) != null && !identity.implies((Permission)((Object)(permission = BatchPermission.forName(targetName))))) {
            throw BatchLogger.LOGGER.unauthorized(identity.getPrincipal().getName(), (Permission)((Object)permission));
        }
    }

    private synchronized void validateJob(String name) {
        if (name == null || "*".equals(name)) {
            return;
        }
        if (!this.resolver.isValidJobName(name)) {
            throw BatchLogger.LOGGER.noSuchJobException(name);
        }
    }

    private class BatchJobServerActivity
    implements ServerActivity,
    PropertyChangeListener {
        private final AtomicBoolean jobsStopped = new AtomicBoolean(false);
        private final AtomicBoolean jobsRestarted = new AtomicBoolean(false);
        private final Collection<Long> stoppedIds = Collections.synchronizedCollection(new ArrayList());
        private boolean suspended;
        private boolean running;

        private BatchJobServerActivity() {
        }

        public void preSuspend(ServerActivityCallback serverActivityCallback) {
            serverActivityCallback.done();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void suspended(ServerActivityCallback serverActivityCallback) {
            BatchJobServerActivity batchJobServerActivity = this;
            synchronized (batchJobServerActivity) {
                this.suspended = true;
            }
            try {
                this.stopRunningJobs(this.isRestartOnResume());
            }
            finally {
                serverActivityCallback.done();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resume() {
            boolean doResume;
            BatchJobServerActivity batchJobServerActivity = this;
            synchronized (batchJobServerActivity) {
                this.suspended = false;
                doResume = this.running;
            }
            if (doResume) {
                this.restartStoppedJobs();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            boolean doResume;
            BatchJobServerActivity batchJobServerActivity = this;
            synchronized (batchJobServerActivity) {
                ControlledProcessState.State newState = (ControlledProcessState.State)evt.getNewValue();
                this.running = newState.isRunning();
                doResume = this.running && !this.suspended;
            }
            if (doResume) {
                this.restartStoppedJobs();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopRunningJobs(boolean queueForRestart) {
            if (this.jobsStopped.compareAndSet(false, true)) {
                ClassLoader current = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
                JobOperatorService.this.permissionsCheckEnabled.set(Boolean.FALSE);
                try {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)JobOperatorService.this.classLoader);
                    Set<String> jobNames = JobOperatorService.this.getJobNames();
                    for (String jobName : jobNames) {
                        List runningJobs = (List)JobOperatorService.this.allowMissingJob(() -> JobOperatorService.this.getRunningExecutions(jobName), Collections.emptyList());
                        for (Long id : runningJobs) {
                            try {
                                BatchLogger.LOGGER.stoppingJob(id, jobName, JobOperatorService.this.deploymentName);
                                JobOperatorService.this.stop(id);
                                if (!queueForRestart) continue;
                                this.stoppedIds.add(id);
                            }
                            catch (Exception e) {
                                BatchLogger.LOGGER.stoppingJobFailed(e, id, jobName, JobOperatorService.this.deploymentName);
                            }
                        }
                    }
                }
                finally {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
                    this.jobsStopped.set(false);
                    JobOperatorService.this.permissionsCheckEnabled.set(Boolean.TRUE);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void restartStoppedJobs() {
            if (this.isRestartOnResume() && this.jobsRestarted.compareAndSet(false, true)) {
                ClassLoader current = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
                try {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)JobOperatorService.this.classLoader);
                    ArrayList<Long> ids = new ArrayList<Long>();
                    Collection<Long> collection = this.stoppedIds;
                    synchronized (collection) {
                        ids.addAll(this.stoppedIds);
                        this.stoppedIds.clear();
                    }
                    for (Long id : ids) {
                        String jobName = null;
                        String user = null;
                        try {
                            JobExecutionImpl execution = JobOperatorService.this.getJobExecutionImpl(id);
                            jobName = execution.getJobName();
                            user = execution.getUser();
                        }
                        catch (Exception execution) {
                            // empty catch block
                        }
                        try {
                            long newId = user == null ? JobOperatorService.this.restart(id, RESTART_PROPS) : this.privilegedRunAs(user, () -> JobOperatorService.this.restart(id, RESTART_PROPS)).longValue();
                            BatchLogger.LOGGER.restartingJob(jobName, id, newId);
                        }
                        catch (Exception e) {
                            BatchLogger.LOGGER.failedRestartingJob(e, id, jobName, JobOperatorService.this.deploymentName);
                        }
                    }
                }
                finally {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
                    this.jobsRestarted.set(false);
                }
            }
        }

        private <V> V privilegedRunAs(String user, Callable<V> callable) throws Exception {
            SecurityDomain securityDomain = JobOperatorService.this.getBatchEnvironment().getSecurityDomain();
            if (securityDomain == null) {
                return callable.call();
            }
            SecurityIdentity securityIdentity = user != null ? (WildFlySecurityManager.isChecking() ? AccessController.doPrivileged(() -> securityDomain.getAnonymousSecurityIdentity().createRunAsIdentity(user, false)) : securityDomain.getAnonymousSecurityIdentity().createRunAsIdentity(user, false)) : securityDomain.getCurrentSecurityIdentity();
            return (V)securityIdentity.runAs(callable);
        }

        private boolean isRestartOnResume() {
            if (JobOperatorService.this.restartJobsOnResume == null) {
                return ((BatchConfiguration)JobOperatorService.this.batchConfigurationInjector.getValue()).isRestartOnResume();
            }
            return JobOperatorService.this.restartJobsOnResume;
        }
    }
}

