/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.AbstractLocationConfigSourceLoader;
import io.smallrye.config.ConfigMessages;
import io.smallrye.config.PropertiesConfigSource;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

public class PropertiesConfigSourceProvider
extends AbstractLocationConfigSourceLoader
implements ConfigSourceProvider {
    private final List<ConfigSource> configSources = new ArrayList<ConfigSource>();
    private final boolean includeFileSystem;

    public PropertiesConfigSourceProvider(String location, ClassLoader classLoader) {
        this(location, classLoader, true);
    }

    public PropertiesConfigSourceProvider(String location, ClassLoader classLoader, boolean includeFileSystem) {
        this.includeFileSystem = includeFileSystem;
        this.configSources.addAll(this.loadConfigSources(location, classLoader));
    }

    @Deprecated
    public PropertiesConfigSourceProvider(String location, boolean optional, ClassLoader classLoader) {
        this(location, classLoader);
        if (!optional && this.configSources.isEmpty()) {
            throw ConfigMessages.msg.fileNotFound(location);
        }
    }

    public List<ConfigSource> getConfigSources(ClassLoader forClassLoader) {
        return this.configSources;
    }

    @Override
    protected String[] getFileExtensions() {
        return new String[]{"properties"};
    }

    @Override
    protected ConfigSource loadConfigSource(URL url, int ordinal) throws IOException {
        return new PropertiesConfigSource(url, ordinal);
    }

    @Override
    protected List<ConfigSource> tryFileSystem(URI uri) {
        if (this.includeFileSystem) {
            return super.tryFileSystem(uri);
        }
        return new ArrayList<ConfigSource>();
    }

    public static PropertiesConfigSourceProvider resource(String location, ClassLoader classLoader) {
        return new PropertiesConfigSourceProvider(location, classLoader);
    }

    public static PropertiesConfigSourceProvider classPathResource(String location, ClassLoader classLoader) {
        return new PropertiesConfigSourceProvider(location, classLoader, false);
    }
}

