/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.util.ArrayList;
import java.util.EnumSet;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.wildfly.clustering.marshalling.protostream.AbstractSerializationContextInitializer;
import org.wildfly.clustering.marshalling.protostream.MarshallerProvider;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshallerProvider;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ProviderSerializationContextInitializer<E extends Enum<E>>
extends AbstractSerializationContextInitializer {
    private final EnumSet<E> concreteSuperClassProviders;

    public ProviderSerializationContextInitializer(String resourceName, Class<E> providerClass) {
        this(resourceName, EnumSet.noneOf(providerClass), WildFlySecurityManager.getClassLoaderPrivileged(providerClass));
    }

    public ProviderSerializationContextInitializer(String resourceName, EnumSet<E> concreteSuperClassProviders) {
        this(resourceName, concreteSuperClassProviders, WildFlySecurityManager.getClassLoaderPrivileged(ProviderSerializationContextInitializer.findEnumClass(concreteSuperClassProviders)));
    }

    private static <E extends Enum<E>> Class<E> findEnumClass(EnumSet<E> set) {
        return ((Enum)(set.isEmpty() ? EnumSet.complementOf(set) : set).iterator().next()).getDeclaringClass();
    }

    private ProviderSerializationContextInitializer(String resourceName, EnumSet<E> concreteSuperClassProviders, ClassLoader loader) {
        super(resourceName, loader);
        this.concreteSuperClassProviders = concreteSuperClassProviders;
    }

    public void registerMarshallers(SerializationContext context) {
        ProtoStreamMarshaller<?> marshaller;
        EnumSet<Enum> providers = EnumSet.complementOf(this.concreteSuperClassProviders);
        ArrayList abstractMarshallers = new ArrayList(providers.size());
        for (Enum provider : providers) {
            marshaller = ((ProtoStreamMarshallerProvider)((Object)provider)).getMarshaller();
            if (MarshallerProvider.ClassPredicate.ABSTRACT.test(marshaller.getJavaClass())) {
                abstractMarshallers.add(marshaller);
                continue;
            }
            context.registerMarshaller(marshaller);
        }
        if (!abstractMarshallers.isEmpty()) {
            context.registerMarshallerProvider((SerializationContext.MarshallerProvider)new MarshallerProvider(MarshallerProvider.ClassPredicate.ABSTRACT, abstractMarshallers));
        }
        for (Enum provider : this.concreteSuperClassProviders) {
            marshaller = ((ProtoStreamMarshallerProvider)((Object)provider)).getMarshaller();
            context.registerMarshallerProvider((SerializationContext.MarshallerProvider)new MarshallerProvider(marshaller.getJavaClass()::isAssignableFrom, new BaseMarshaller[]{marshaller}));
        }
    }
}

