/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.wildfly.clustering.marshalling.protostream.AnyField;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.ScalarMarshaller;

public enum ScalarClass implements ScalarMarshaller<Class<?>>
{
    ANY(2){

        @Override
        public Class<?> readFrom(ProtoStreamReader reader) throws IOException {
            return reader.readObject(Class.class);
        }

        @Override
        public void writeTo(ProtoStreamWriter writer, Class<?> value) throws IOException {
            writer.writeObjectNoTag(value);
        }
    }
    ,
    ID(0){

        @Override
        public Class<?> readFrom(ProtoStreamReader reader) throws IOException {
            int typeId = reader.readUInt32();
            ImmutableSerializationContext context = reader.getSerializationContext();
            String typeName = context.getDescriptorByTypeId(Integer.valueOf(typeId)).getFullName();
            BaseMarshaller marshaller = context.getMarshaller(typeName);
            return marshaller.getJavaClass();
        }

        @Override
        public void writeTo(ProtoStreamWriter writer, Class<?> value) throws IOException {
            ImmutableSerializationContext context = writer.getSerializationContext();
            BaseMarshaller marshaller = context.getMarshaller(value);
            String typeName = marshaller.getTypeName();
            int typeId = context.getDescriptorByName(typeName).getTypeId();
            writer.writeUInt32NoTag(typeId);
        }
    }
    ,
    NAME(2){

        @Override
        public Class<?> readFrom(ProtoStreamReader reader) throws IOException {
            ImmutableSerializationContext context = reader.getSerializationContext();
            String typeName = reader.readString();
            BaseMarshaller marshaller = context.getMarshaller(typeName);
            return marshaller.getJavaClass();
        }

        @Override
        public void writeTo(ProtoStreamWriter writer, Class<?> value) throws IOException {
            ImmutableSerializationContext context = writer.getSerializationContext();
            BaseMarshaller marshaller = context.getMarshaller(value);
            String typeName = marshaller.getTypeName();
            writer.writeStringNoTag(typeName);
        }
    }
    ,
    FIELD(0){

        @Override
        public Class<?> readFrom(ProtoStreamReader reader) throws IOException {
            return AnyField.fromIndex(reader.readUInt32() + 1).getMarshaller().getJavaClass();
        }

        @Override
        public void writeTo(ProtoStreamWriter writer, Class<?> value) throws IOException {
            writer.writeUInt32NoTag(AnyField.fromJavaType(value).getIndex() - 1);
        }
    };

    private final int wireType;

    private ScalarClass(int wireType) {
        this.wireType = wireType;
    }

    @Override
    public Class<? extends Class<?>> getJavaClass() {
        return Class.class;
    }

    @Override
    public int getWireType() {
        return this.wireType;
    }
}

