/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.protocol.remote;

import java.io.IOException;
import java.net.ConnectException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.DiscoveryEJBClientInterceptor;
import org.jboss.ejb.client.EJBClientConnection;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBModuleIdentifier;
import org.jboss.ejb.protocol.remote.DiscoveredNodeRegistry;
import org.jboss.ejb.protocol.remote.EJBClientChannel;
import org.jboss.ejb.protocol.remote.NodeInformation;
import org.jboss.ejb.protocol.remote.RemoteEJBReceiver;
import org.jboss.ejb.protocol.remote.RemoteTransportProvider;
import org.jboss.ejb.protocol.remote.SecurityUtils;
import org.jboss.logging.Logger;
import org.jboss.remoting3.ConnectionPeerIdentity;
import org.jboss.remoting3.Endpoint;
import org.wildfly.common.Assert;
import org.wildfly.common.net.CidrAddressTable;
import org.wildfly.common.net.Inet;
import org.wildfly.discovery.AllFilterSpec;
import org.wildfly.discovery.AttributeValue;
import org.wildfly.discovery.EqualsFilterSpec;
import org.wildfly.discovery.FilterSpec;
import org.wildfly.discovery.ServiceType;
import org.wildfly.discovery.ServiceURL;
import org.wildfly.discovery.spi.DiscoveryProvider;
import org.wildfly.discovery.spi.DiscoveryRequest;
import org.wildfly.discovery.spi.DiscoveryResult;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.xnio.FailedIoFuture;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

final class RemotingEJBDiscoveryProvider
implements DiscoveryProvider,
DiscoveredNodeRegistry {
    static final AuthenticationContextConfigurationClient AUTH_CONFIGURATION_CLIENT = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
    private final ConcurrentHashMap<String, NodeInformation> nodes = new ConcurrentHashMap();
    private final Map<URI, Long> failedDestinations = new ConcurrentHashMap<URI, Long>();
    private final ConcurrentHashMap<String, Set<String>> clusterNodes = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, URI> effectiveAuthURIs = new ConcurrentHashMap();
    private static final long DESTINATION_RECHECK_INTERVAL = TimeUnit.MILLISECONDS.toNanos(SecurityUtils.getLong("org.jboss.ejb.client.destination-recheck-interval", 5000L));
    static final FilterSpec.Visitor<Void, EJBModuleIdentifier, RuntimeException> MI_EXTRACTOR = new FilterSpec.Visitor<Void, EJBModuleIdentifier, RuntimeException>(){

        public EJBModuleIdentifier handle(EqualsFilterSpec filterSpec, Void parameter) throws RuntimeException {
            return RemotingEJBDiscoveryProvider.getIdentifierForAttribute(filterSpec.getAttribute(), filterSpec.getValue());
        }

        public EJBModuleIdentifier handle(AllFilterSpec filterSpec, Void parameter) throws RuntimeException {
            for (FilterSpec child : filterSpec) {
                EJBModuleIdentifier match = (EJBModuleIdentifier)child.accept((FilterSpec.Visitor)this);
                if (match == null) continue;
                return match;
            }
            return null;
        }
    };
    static final FilterSpec.Visitor<Void, String, RuntimeException> NODE_EXTRACTOR = new FilterSpec.Visitor<Void, String, RuntimeException>(){

        public String handle(EqualsFilterSpec filterSpec, Void parameter) throws RuntimeException {
            AttributeValue value = filterSpec.getValue();
            return filterSpec.getAttribute().equals("node") && value.isString() ? value.toString() : null;
        }

        public String handle(AllFilterSpec filterSpec, Void parameter) throws RuntimeException {
            for (FilterSpec child : filterSpec) {
                String match = (String)child.accept((FilterSpec.Visitor)this);
                if (match == null) continue;
                return match;
            }
            return null;
        }
    };

    public RemotingEJBDiscoveryProvider() {
        Endpoint.getCurrent();
    }

    @Override
    public NodeInformation getNodeInformation(String nodeName) {
        return this.nodes.computeIfAbsent(nodeName, NodeInformation::new);
    }

    @Override
    public List<NodeInformation> getAllNodeInformation() {
        return new ArrayList<NodeInformation>(this.nodes.values());
    }

    @Override
    public void addNode(String clusterName, String nodeName, URI registeredBy) {
        this.effectiveAuthURIs.putIfAbsent(clusterName, registeredBy);
        this.clusterNodes.computeIfAbsent(clusterName, ignored -> Collections.newSetFromMap(new ConcurrentHashMap())).add(nodeName);
    }

    @Override
    public void removeNode(String clusterName, String nodeName) {
        this.clusterNodes.getOrDefault(clusterName, Collections.emptySet()).remove(nodeName);
    }

    @Override
    public void removeCluster(String clusterName) {
        Set<String> removed = this.clusterNodes.remove(clusterName);
        if (removed != null) {
            removed.clear();
        }
        this.effectiveAuthURIs.remove(clusterName);
    }

    private boolean haveNotExpiredFailedDestination(URI uri) {
        if (!this.failedDestinations.containsKey(uri)) {
            return false;
        }
        long failureTimestamp = this.failedDestinations.get(uri);
        long delta = System.nanoTime() - failureTimestamp;
        return delta < DESTINATION_RECHECK_INTERVAL;
    }

    public DiscoveryRequest discover(ServiceType serviceType, FilterSpec filterSpec, DiscoveryResult result) {
        if (!serviceType.implies(ServiceType.of((String)"ejb", (String)"jboss"))) {
            Logs.INVOCATION.tracef("EJB discovery provider: wrong service type(%s), returning!", serviceType.toString());
            result.complete();
            return DiscoveryRequest.NULL;
        }
        EJBClientContext ejbClientContext = EJBClientContext.getCurrent();
        RemoteEJBReceiver ejbReceiver = ejbClientContext.getAttachment(RemoteTransportProvider.ATTACHMENT_KEY);
        if (ejbReceiver == null) {
            Logs.INVOCATION.tracef("EJB discovery provider: no EJBReceiver available, returning!", new Object[0]);
            result.complete();
            return DiscoveryRequest.NULL;
        }
        List<EJBClientConnection> configuredConnections = ejbClientContext.getConfiguredConnections();
        DiscoveryAttempt discoveryAttempt = new DiscoveryAttempt(serviceType, filterSpec, result, ejbReceiver, AuthenticationContext.captureCurrent());
        boolean ok = false;
        boolean discoveryConnections = false;
        for (EJBClientConnection eJBClientConnection : configuredConnections) {
            if (!eJBClientConnection.isForDiscovery()) {
                Logs.INVOCATION.tracef("EJB discovery provider: found non-discovery connection, skipping", new Object[0]);
                continue;
            }
            discoveryConnections = true;
            URI uri = eJBClientConnection.getDestination();
            if (this.haveNotExpiredFailedDestination(uri)) {
                Logs.INVOCATION.tracef("EJB discovery provider: attempting to connect to configured connection %s, skipping because marked as failed", uri);
                continue;
            }
            ok = true;
            Logs.INVOCATION.tracef("EJB discovery provider: attempting to connect to configured connection %s", uri);
            discoveryAttempt.connectAndDiscover(uri, null);
        }
        block4: for (Map.Entry entry : this.clusterNodes.entrySet()) {
            String clusterName = (String)entry.getKey();
            Set nodeSet = (Set)entry.getValue();
            int maxConnections = ejbClientContext.getMaximumConnectedClusterNodes();
            block5: for (String nodeName : nodeSet) {
                NodeInformation.ClusterNodeInformation clusterInfo;
                if (maxConnections <= 0) continue block4;
                NodeInformation nodeInformation = this.nodes.get(nodeName);
                if (nodeInformation == null || (clusterInfo = (NodeInformation.ClusterNodeInformation)nodeInformation.getClustersByName().get(clusterName)) == null) continue;
                Map<String, CidrAddressTable<InetSocketAddress>> tables = clusterInfo.getAddressTablesByProtocol();
                for (Map.Entry<String, CidrAddressTable<InetSocketAddress>> entry2 : tables.entrySet()) {
                    String protocol = entry2.getKey();
                    CidrAddressTable<InetSocketAddress> addressTable = entry2.getValue();
                    for (CidrAddressTable.Mapping mapping : addressTable) {
                        try {
                            URI uri;
                            InetSocketAddress destination = Inet.getResolved((InetSocketAddress)((InetSocketAddress)mapping.getValue()));
                            InetSocketAddress source = ejbReceiver.getSourceAddress(destination);
                            if (!(source == null ? mapping.getRange().getNetmaskBits() == 0 : source.equals(destination))) continue;
                            InetAddress destinationAddress = destination.getAddress();
                            String hostName = Inet.getHostNameIfResolved((InetAddress)destinationAddress);
                            if (hostName == null) {
                                hostName = destinationAddress instanceof Inet6Address ? '[' + Inet.toOptimalString((InetAddress)destinationAddress) + ']' : Inet.toOptimalString((InetAddress)destinationAddress);
                            }
                            if (this.haveNotExpiredFailedDestination(uri = new URI(protocol, null, hostName, destination.getPort(), null, null, null))) {
                                Logs.INVOCATION.tracef("EJB discovery provider: attempting to connect to cluster connection %s, skipping because marked as failed", uri);
                                continue;
                            }
                            --maxConnections;
                            Logs.INVOCATION.tracef("EJB discovery provider: attempting to connect to cluster %s connection %s", clusterName, uri);
                            discoveryAttempt.connectAndDiscover(uri, clusterName);
                            ok = true;
                            continue block5;
                        }
                        catch (URISyntaxException destination) {
                        }
                        catch (UnknownHostException e) {
                            Logs.MAIN.logf(Logger.Level.DEBUG, "Cannot resolve %s host during discovery attempt, skipping", mapping.getValue());
                        }
                    }
                }
            }
        }
        if (discoveryConnections && !ok) {
            Logs.INVOCATION.tracef("EJB discovery provider: all discovery-enabled configured connections marked failed, retrying configured connections ...", new Object[0]);
            for (EJBClientConnection eJBClientConnection : configuredConnections) {
                if (!eJBClientConnection.isForDiscovery()) continue;
                URI destination = eJBClientConnection.getDestination();
                Logs.INVOCATION.tracef("EJB discovery provider: attempting to connect to connection %s", destination);
                discoveryAttempt.connectAndDiscover(destination, null);
            }
        }
        discoveryAttempt.countDown();
        return discoveryAttempt;
    }

    static EJBModuleIdentifier getIdentifierForAttribute(String attribute, AttributeValue value) {
        if (!value.isString()) {
            return null;
        }
        String stringVal = value.toString();
        switch (attribute) {
            case "ejb-module": {
                String module;
                String app;
                String[] segments = stringVal.split("/");
                if (segments.length == 2) {
                    app = segments[0];
                    module = segments[1];
                } else if (segments.length == 1) {
                    app = "";
                    module = segments[0];
                } else {
                    return null;
                }
                return new EJBModuleIdentifier(app, module, "");
            }
            case "ejb-module-distinct": {
                String distinct;
                String module;
                String app;
                String[] segments = stringVal.split("/");
                if (segments.length == 3) {
                    app = segments[0];
                    module = segments[1];
                    distinct = segments[2];
                } else if (segments.length == 2) {
                    app = "";
                    module = segments[0];
                    distinct = segments[1];
                } else {
                    return null;
                }
                return new EJBModuleIdentifier(app, module, distinct);
            }
        }
        return null;
    }

    IoFuture<ConnectionPeerIdentity> getConnectedIdentityUsingClusterEffective(Endpoint endpoint, URI destination, String abstractType, String abstractTypeAuthority, AuthenticationContext context, String clusterName) {
        SSLContext sslContext;
        boolean updateAuth;
        Assert.checkNotNullParam((String)"destination", (Object)destination);
        Assert.checkNotNullParam((String)"context", (Object)context);
        URI effectiveAuth = clusterName != null ? this.effectiveAuthURIs.get(clusterName) : null;
        boolean bl = updateAuth = effectiveAuth != null;
        if (!updateAuth) {
            effectiveAuth = destination;
        }
        AuthenticationContextConfigurationClient client = AUTH_CONFIGURATION_CLIENT;
        try {
            sslContext = client.getSSLContext(destination, context);
        }
        catch (GeneralSecurityException e) {
            return new FailedIoFuture(Logs.REMOTING.failedToConfigureSslContext(e));
        }
        AuthenticationConfiguration authenticationConfiguration = client.getAuthenticationConfiguration(effectiveAuth, context, -1, abstractType, abstractTypeAuthority);
        return endpoint.getConnectedIdentity(destination, sslContext, updateAuth ? this.fixupOverrides(authenticationConfiguration, destination) : authenticationConfiguration);
    }

    private AuthenticationConfiguration fixupOverrides(AuthenticationConfiguration config, URI target) {
        return config.useProtocol(target.getScheme()).useHost(target.getHost()).usePort(target.getPort());
    }

    final class DiscoveryAttempt
    implements DiscoveryRequest,
    DiscoveryResult {
        private final ServiceType serviceType;
        private final FilterSpec filterSpec;
        private final DiscoveryResult discoveryResult;
        private final RemoteEJBReceiver ejbReceiver;
        private final AuthenticationContext authenticationContext;
        private final Endpoint endpoint;
        private final AtomicInteger outstandingCount = new AtomicInteger(1);
        private volatile boolean phase2;
        private final List<Runnable> cancellers = Collections.synchronizedList(new ArrayList());
        private final IoFuture.HandlingNotifier<ConnectionPeerIdentity, URI> outerNotifier;
        private final IoFuture.HandlingNotifier<EJBClientChannel, URI> innerNotifier;
        private final ConcurrentHashMap<String, Set<URI>> urisByCluster = new ConcurrentHashMap();
        private final Set<URI> connectFailedURIs = new HashSet<URI>();
        private final Set<String> eagerNodes;

        DiscoveryAttempt(ServiceType serviceType, FilterSpec filterSpec, DiscoveryResult discoveryResult, RemoteEJBReceiver ejbReceiver, AuthenticationContext authenticationContext) {
            this.serviceType = serviceType;
            this.filterSpec = filterSpec;
            this.discoveryResult = discoveryResult;
            this.ejbReceiver = ejbReceiver;
            this.authenticationContext = authenticationContext;
            this.endpoint = Endpoint.getCurrent();
            this.outerNotifier = new IoFuture.HandlingNotifier<ConnectionPeerIdentity, URI>(){

                public void handleCancelled(URI destination) {
                    DiscoveryAttempt.this.countDown();
                }

                public void handleFailed(IOException exception, URI destination) {
                    DiscoveryAttempt.this.discoveryResult.reportProblem((Throwable)exception);
                    RemotingEJBDiscoveryProvider.this.failedDestinations.put(destination, System.nanoTime());
                    if (exception instanceof ConnectException) {
                        DiscoveryAttempt.this.connectFailedURIs.add(destination);
                        Logs.INVOCATION.tracef("DiscoveryAttempt: got ConnectException on node with destination = %s", destination);
                    }
                    DiscoveryAttempt.this.countDown();
                }

                public void handleDone(ConnectionPeerIdentity data, URI destination) {
                    IoFuture future = ((DiscoveryAttempt)DiscoveryAttempt.this).ejbReceiver.serviceHandle.getClientService(data.getConnection(), OptionMap.EMPTY);
                    DiscoveryAttempt.this.onCancel(() -> ((IoFuture)future).cancel());
                    future.addNotifier((IoFuture.Notifier)DiscoveryAttempt.this.innerNotifier, (Object)destination);
                }
            };
            this.innerNotifier = new IoFuture.HandlingNotifier<EJBClientChannel, URI>(){

                public void handleCancelled(URI destination) {
                    DiscoveryAttempt.this.countDown();
                }

                public void handleFailed(IOException exception, URI destination) {
                    DiscoveryAttempt.this.discoveryResult.reportProblem((Throwable)exception);
                    RemotingEJBDiscoveryProvider.this.failedDestinations.put(destination, System.nanoTime());
                    DiscoveryAttempt.this.countDown();
                }

                public void handleDone(EJBClientChannel clientChannel, URI destination) {
                    RemotingEJBDiscoveryProvider.this.failedDestinations.remove(destination);
                    DiscoveryAttempt.this.countDown();
                }
            };
            this.eagerNodes = DiscoveryEJBClientInterceptor.getDiscoveryAdditionalTimeout() == 0L ? null : Collections.synchronizedSet(new HashSet());
        }

        void connectAndDiscover(URI uri, String clusterEffective) {
            String scheme = uri.getScheme();
            if (scheme == null || !this.ejbReceiver.getRemoteTransportProvider().supportsProtocol(scheme) || !this.endpoint.isValidUriScheme(scheme)) {
                this.countDown();
                return;
            }
            this.outstandingCount.getAndIncrement();
            if (clusterEffective != null) {
                this.urisByCluster.computeIfAbsent(clusterEffective, ignored -> Collections.newSetFromMap(new ConcurrentHashMap())).add(uri);
            }
            IoFuture<ConnectionPeerIdentity> future = System.getSecurityManager() == null ? RemotingEJBDiscoveryProvider.this.getConnectedIdentityUsingClusterEffective(this.endpoint, uri, "ejb", "jboss", this.authenticationContext, clusterEffective) : AccessController.doPrivileged(() -> RemotingEJBDiscoveryProvider.this.getConnectedIdentityUsingClusterEffective(this.endpoint, uri, "ejb", "jboss", this.authenticationContext, clusterEffective));
            this.onCancel(() -> future.cancel());
            future.addNotifier(this.outerNotifier, (Object)uri);
        }

        void countDown() {
            if (this.outstandingCount.decrementAndGet() == 0) {
                for (String cluster : this.urisByCluster.keySet()) {
                    URI uri;
                    Set<URI> uris = this.urisByCluster.get(cluster);
                    if (uris == null || uris.size() != 1 || !this.connectFailedURIs.contains(uri = uris.iterator().next())) continue;
                    Logs.INVOCATION.tracef("DiscoveryAttempt: countDown() found a cluster %s with one failed destination, %s, removing cluster", cluster, uri);
                    RemotingEJBDiscoveryProvider.this.removeCluster(cluster);
                    for (NodeInformation nodeInformation : RemotingEJBDiscoveryProvider.this.getAllNodeInformation()) {
                        nodeInformation.removeCluster(cluster);
                    }
                }
                DiscoveryResult result = this.discoveryResult;
                String node = (String)this.filterSpec.accept(NODE_EXTRACTOR);
                EJBModuleIdentifier module = (EJBModuleIdentifier)this.filterSpec.accept(MI_EXTRACTOR);
                if (this.phase2) {
                    if (node != null) {
                        Object information;
                        if (!(this.eagerNodes != null && this.eagerNodes.contains(node) || (information = (NodeInformation)RemotingEJBDiscoveryProvider.this.nodes.get(node)) == null)) {
                            ((NodeInformation)information).discover(this.serviceType, this.filterSpec, result);
                        }
                    } else {
                        for (Object information : RemotingEJBDiscoveryProvider.this.nodes.values()) {
                            if (this.eagerNodes != null && this.eagerNodes.contains(((NodeInformation)information).getNodeName())) continue;
                            ((NodeInformation)information).discover(this.serviceType, this.filterSpec, result);
                        }
                    }
                    result.complete();
                } else {
                    boolean ok = false;
                    if (node != null) {
                        Object information;
                        if ((this.eagerNodes == null || !this.eagerNodes.contains(node)) && (information = (NodeInformation)RemotingEJBDiscoveryProvider.this.nodes.get(node)) != null && ((NodeInformation)information).discover(this.serviceType, this.filterSpec, result)) {
                            ok = true;
                        }
                    } else {
                        for (NodeInformation information : RemotingEJBDiscoveryProvider.this.nodes.values()) {
                            if (this.eagerNodes != null && this.eagerNodes.contains(information.getNodeName()) || !information.discover(this.serviceType, this.filterSpec, result)) continue;
                            ok = true;
                        }
                    }
                    if (ok || this.eagerNodes != null && !this.eagerNodes.isEmpty()) {
                        result.complete();
                    } else {
                        HashSet<URI> everything = new HashSet<URI>();
                        HashMap<URI, String> effectiveAuthMappings = new HashMap<URI, String>();
                        for (EJBClientConnection connection : this.ejbReceiver.getReceiverContext().getClientContext().getConfiguredConnections()) {
                            if (!connection.isForDiscovery()) continue;
                            everything.add(connection.getDestination());
                        }
                        block7: for (NodeInformation information : RemotingEJBDiscoveryProvider.this.nodes.values()) {
                            for (Map.Entry entry : information.getClustersByName().entrySet()) {
                                String clusterName = (String)entry.getKey();
                                NodeInformation.ClusterNodeInformation cni = (NodeInformation.ClusterNodeInformation)entry.getValue();
                                Map<String, CidrAddressTable<InetSocketAddress>> atm = cni.getAddressTablesByProtocol();
                                for (Map.Entry<String, CidrAddressTable<InetSocketAddress>> entry2 : atm.entrySet()) {
                                    String protocol = entry2.getKey();
                                    CidrAddressTable<InetSocketAddress> addressTable = entry2.getValue();
                                    for (CidrAddressTable.Mapping mapping : addressTable) {
                                        try {
                                            InetSocketAddress destination = Inet.getResolved((InetSocketAddress)((InetSocketAddress)mapping.getValue()));
                                            InetSocketAddress source = this.ejbReceiver.getSourceAddress(destination);
                                            if (!(source == null ? mapping.getRange().getNetmaskBits() == 0 : source.equals(destination))) continue;
                                            InetAddress destinationAddress = destination.getAddress();
                                            String hostName = Inet.getHostNameIfResolved((InetAddress)destinationAddress);
                                            if (hostName == null) {
                                                hostName = destinationAddress instanceof Inet6Address ? '[' + Inet.toOptimalString((InetAddress)destinationAddress) + ']' : Inet.toOptimalString((InetAddress)destinationAddress);
                                            }
                                            URI location = new URI(protocol, null, hostName, destination.getPort(), null, null, null);
                                            effectiveAuthMappings.put(location, clusterName);
                                            everything.add(location);
                                            continue block7;
                                        }
                                        catch (URISyntaxException | UnknownHostException exception) {
                                        }
                                    }
                                }
                            }
                        }
                        this.phase2 = true;
                        this.outstandingCount.incrementAndGet();
                        for (URI uri : everything) {
                            if (RemotingEJBDiscoveryProvider.this.failedDestinations.containsKey(uri)) continue;
                            this.connectAndDiscover(uri, (String)effectiveAuthMappings.get(uri));
                        }
                        this.countDown();
                    }
                }
            } else if (this.eagerNodes != null) {
                DiscoveryResult result = this.discoveryResult;
                String node = (String)this.filterSpec.accept(NODE_EXTRACTOR);
                if (node != null) {
                    NodeInformation information;
                    if (!this.eagerNodes.contains(node) && (information = (NodeInformation)RemotingEJBDiscoveryProvider.this.nodes.get(node)) != null && information.discover(this.serviceType, this.filterSpec, result)) {
                        this.eagerNodes.add(node);
                    }
                } else {
                    for (NodeInformation information : RemotingEJBDiscoveryProvider.this.nodes.values()) {
                        if (this.eagerNodes.contains(information.getNodeName()) || !information.discover(this.serviceType, this.filterSpec, result)) continue;
                        this.eagerNodes.add(information.getNodeName());
                    }
                }
            }
        }

        public void complete() {
            this.countDown();
        }

        public void reportProblem(Throwable description) {
            this.discoveryResult.reportProblem(description);
        }

        public void addMatch(ServiceURL serviceURL) {
            this.discoveryResult.addMatch(serviceURL);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            List<Runnable> cancellers;
            List<Runnable> list = cancellers = this.cancellers;
            synchronized (list) {
                for (Runnable canceller : cancellers) {
                    canceller.run();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onCancel(Runnable action) {
            List<Runnable> cancellers;
            List<Runnable> list = cancellers = this.cancellers;
            synchronized (list) {
                cancellers.add(action);
            }
        }
    }
}

