/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.accesscontrol;

import org.jboss.as.cli.accesscontrol.AddressAccessRequirement;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultPrefixFormatter;

public abstract class BaseOperationAccessRequirement
extends AddressAccessRequirement {
    protected final String operation;
    protected String toString;

    BaseOperationAccessRequirement(String operation) {
        this(new DefaultOperationRequestAddress(), operation);
    }

    BaseOperationAccessRequirement(String address, String operation) {
        super(address);
        if (operation == null) {
            throw new IllegalArgumentException("operation is null");
        }
        this.operation = operation;
    }

    BaseOperationAccessRequirement(OperationRequestAddress address, String operation) {
        super(address);
        if (operation == null) {
            throw new IllegalArgumentException("operation is null");
        }
        this.operation = operation;
    }

    public String toString() {
        if (this.toString == null) {
            StringBuilder buf = new StringBuilder();
            if (this.address != null) {
                buf.append(DefaultPrefixFormatter.INSTANCE.format(this.address));
            }
            buf.append(':').append(this.operation);
            this.toString = buf.toString();
        }
        return this.toString;
    }
}

