/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml;

import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.jboss.security.xacml.sunxacml.attr.BagAttribute;
import org.jboss.security.xacml.sunxacml.attr.DateAttribute;
import org.jboss.security.xacml.sunxacml.attr.DateTimeAttribute;
import org.jboss.security.xacml.sunxacml.attr.StringAttribute;
import org.jboss.security.xacml.sunxacml.attr.TimeAttribute;
import org.jboss.security.xacml.sunxacml.cond.EvaluationResult;
import org.jboss.security.xacml.sunxacml.ctx.Attribute;
import org.jboss.security.xacml.sunxacml.ctx.RequestCtx;
import org.jboss.security.xacml.sunxacml.ctx.Subject;
import org.jboss.security.xacml.sunxacml.finder.AttributeFinder;
import org.w3c.dom.Node;

public class BasicEvaluationCtx
implements EvaluationCtx {
    private AttributeFinder finder;
    private Node requestRoot;
    private HashMap subjectMap;
    private HashMap resourceMap;
    private HashMap actionMap;
    private HashMap environmentMap;
    private AttributeValue resourceId;
    private int scope;
    private DateAttribute currentDate;
    private TimeAttribute currentTime;
    private DateTimeAttribute currentDateTime;
    private boolean useCachedEnvValues;
    private static final Logger logger = Logger.getLogger(BasicEvaluationCtx.class.getName());

    public BasicEvaluationCtx(RequestCtx request) throws ParsingException {
        this(request, null, true);
    }

    public BasicEvaluationCtx(RequestCtx request, boolean cacheEnvValues) throws ParsingException {
        this(request, null, cacheEnvValues);
    }

    public BasicEvaluationCtx(RequestCtx request, AttributeFinder finder) throws ParsingException {
        this(request, finder, true);
    }

    public BasicEvaluationCtx(RequestCtx request, AttributeFinder finder, boolean cacheEnvValues) throws ParsingException {
        this.finder = finder;
        this.requestRoot = request.getDocumentRoot();
        this.useCachedEnvValues = cacheEnvValues;
        this.currentDate = null;
        this.currentTime = null;
        this.currentDateTime = null;
        this.subjectMap = new HashMap();
        this.setupSubjects(request.getSubjectsAsList());
        this.resourceMap = new HashMap();
        this.setupResource(request.getResourceAsList());
        this.actionMap = new HashMap();
        this.mapAttributes(request.getActionAsList(), this.actionMap);
        this.environmentMap = new HashMap();
        this.mapAttributes(request.getEnvironmentAttributesAsList(), this.environmentMap);
    }

    private void setupSubjects(List subjects) throws ParsingException {
        if (subjects.size() == 0) {
            throw new ParsingException("Request must a contain subject");
        }
        for (Subject subject : subjects) {
            URI category = subject.getCategory();
            Map categoryMap = null;
            if (this.subjectMap.containsKey(category)) {
                categoryMap = (Map)this.subjectMap.get(category);
            } else {
                categoryMap = new HashMap();
                this.subjectMap.put(category, categoryMap);
            }
            for (Attribute attr : subject.getAttributesAsList()) {
                String id = attr.getId().toString();
                if (categoryMap.containsKey(id)) {
                    List existingIds = (List)categoryMap.get(id);
                    existingIds.add(attr);
                    continue;
                }
                ArrayList<Attribute> newIds = new ArrayList<Attribute>();
                newIds.add(attr);
                categoryMap.put(id, newIds);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setupResource(List resource) throws ParsingException {
        this.mapAttributes(resource, this.resourceMap);
        if (!this.resourceMap.containsKey("urn:oasis:names:tc:xacml:1.0:resource:resource-id")) {
            System.err.println("Resource must contain resource-id attr");
        }
        if (this.resourceId == null) {
            this.resourceId = new StringAttribute("");
        }
        if (!this.resourceMap.containsKey("urn:oasis:names:tc:xacml:1.0:resource:scope")) {
            this.scope = 0;
            return;
        }
        Set set = (Set)this.resourceMap.get("urn:oasis:names:tc:xacml:1.0:resource:scope");
        if (set.size() > 1) {
            System.err.println("Resource may contain only one resource-scope Attribute");
            throw new ParsingException("too many resource-scope attrs");
        }
        Attribute attr = (Attribute)set.iterator().next();
        AttributeValue attrValue = attr.getValue();
        if (!attrValue.getType().toString().equals("http://www.w3.org/2001/XMLSchema#string")) {
            throw new ParsingException("scope attr must be a string");
        }
        String value = ((StringAttribute)attrValue).getValue();
        if (value.equals("Immediate")) {
            this.scope = 0;
            return;
        }
        if (value.equals("Children")) {
            this.scope = 1;
            return;
        }
        if (value.equals("Descendants")) {
            this.scope = 2;
            return;
        }
        System.err.println("Unknown scope type: " + value);
        throw new ParsingException("invalid scope type: " + value);
    }

    private void mapAttributes(List input, Map output) {
        for (Attribute attr : input) {
            List<Attribute> set;
            String id = attr.getId().toString();
            if (output.containsKey(id)) {
                set = (List)output.get(id);
                set.add(attr);
                continue;
            }
            set = new ArrayList<Attribute>();
            set.add(attr);
            output.put(id, set);
        }
    }

    public Node getRequestRoot() {
        return this.requestRoot;
    }

    public int getScope() {
        return this.scope;
    }

    public AttributeValue getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(AttributeValue resourceId) {
        this.resourceId = resourceId;
        Set attrSet = (Set)this.resourceMap.get("urn:oasis:names:tc:xacml:1.0:resource:resource-id");
        Attribute attr = (Attribute)attrSet.iterator().next();
        attrSet.remove(attr);
        attrSet.add(new Attribute(attr.getId(), attr.getIssuer(), attr.getIssueInstant(), resourceId));
    }

    public synchronized TimeAttribute getCurrentTime() {
        long millis = this.dateTimeHelper();
        if (this.useCachedEnvValues) {
            return this.currentTime;
        }
        return new TimeAttribute(new Date(millis));
    }

    public synchronized DateAttribute getCurrentDate() {
        long millis = this.dateTimeHelper();
        if (this.useCachedEnvValues) {
            return this.currentDate;
        }
        return new DateAttribute(new Date(millis));
    }

    public synchronized DateTimeAttribute getCurrentDateTime() {
        long millis = this.dateTimeHelper();
        if (this.useCachedEnvValues) {
            return this.currentDateTime;
        }
        return new DateTimeAttribute(new Date(millis));
    }

    private long dateTimeHelper() {
        if (this.currentTime != null) {
            return -1L;
        }
        Date time = new Date();
        long millis = time.getTime();
        if (!this.useCachedEnvValues) {
            return millis;
        }
        this.currentTime = new TimeAttribute(time);
        this.currentDate = new DateAttribute(new Date(millis));
        this.currentDateTime = new DateTimeAttribute(new Date(millis));
        return -1L;
    }

    public EvaluationResult getSubjectAttribute(URI type, URI id, URI category) {
        return this.getSubjectAttribute(type, id, null, category);
    }

    public EvaluationResult getSubjectAttribute(URI type, URI id, URI issuer, URI category) {
        Map map = (Map)this.subjectMap.get(category);
        if (map == null) {
            return this.callHelper(type, id, issuer, category, 0);
        }
        return this.getGenericAttributes(type, id, issuer, map, category, 0);
    }

    public EvaluationResult getResourceAttribute(URI type, URI id, URI issuer) {
        return this.getGenericAttributes(type, id, issuer, this.resourceMap, null, 1);
    }

    public EvaluationResult getActionAttribute(URI type, URI id, URI issuer) {
        return this.getGenericAttributes(type, id, issuer, this.actionMap, null, 2);
    }

    public EvaluationResult getEnvironmentAttribute(URI type, URI id, URI issuer) {
        return this.getGenericAttributes(type, id, issuer, this.environmentMap, null, 3);
    }

    private EvaluationResult getGenericAttributes(URI type, URI id, URI issuer, Map map, URI category, int designatorType) {
        List attrSet = (List)map.get(id.toString());
        if (attrSet == null) {
            return this.callHelper(type, id, issuer, category, designatorType);
        }
        ArrayList<AttributeValue> attributes = new ArrayList<AttributeValue>();
        for (Attribute attr : attrSet) {
            if (!attr.getType().equals(type) || issuer != null && (attr.getIssuer() == null || !attr.getIssuer().equals(issuer.toString()))) continue;
            attributes.addAll(attr.getValues());
        }
        if (attributes.size() == 0) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attribute not in request: " + id.toString() + " ... querying AttributeFinder");
            }
            return this.callHelper(type, id, issuer, category, designatorType);
        }
        return new EvaluationResult(new BagAttribute(type, attributes));
    }

    private EvaluationResult callHelper(URI type, URI id, URI issuer, URI category, int adType) {
        if (this.finder != null) {
            return this.finder.findAttribute(type, id, issuer, category, this, adType);
        }
        logger.warning("Context tried to invoke AttributeFinder but was not configured with one");
        return new EvaluationResult(BagAttribute.createEmptyBag(type));
    }

    public EvaluationResult getAttribute(String contextPath, Node namespaceNode, URI type, String xpathVersion) {
        if (this.finder != null) {
            return this.finder.findAttribute(contextPath, namespaceNode, type, this, xpathVersion);
        }
        logger.warning("Context tried to invoke AttributeFinder but was not configured with one");
        return new EvaluationResult(BagAttribute.createEmptyBag(type));
    }
}

