/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.MultiRetry;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.MultiFlatMapOnFailure;
import io.smallrye.mutiny.operators.multi.MultiOnFailureInvoke;
import io.smallrye.mutiny.operators.multi.MultiOnFailureTransform;
import io.smallrye.mutiny.subscription.Cancellable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class MultiOnFailure<T> {
    private final Multi<T> upstream;
    private final Predicate<? super Throwable> predicate;

    public MultiOnFailure(Multi<T> upstream, Predicate<? super Throwable> predicate) {
        this.upstream = upstream;
        this.predicate = predicate == null ? x -> true : predicate;
    }

    public Multi<T> invoke(Consumer<Throwable> callback) {
        Consumer<Throwable> actual = Infrastructure.decorate(ParameterValidation.nonNull(callback, "callback"));
        return Infrastructure.onMultiCreation(new MultiOnFailureInvoke<T>(this.upstream, actual, this.predicate));
    }

    public Multi<T> invoke(Runnable callback) {
        Runnable actual = ParameterValidation.nonNull(callback, "callback");
        return this.invoke((Throwable ignored) -> actual.run());
    }

    public Multi<T> call(Function<Throwable, Uni<?>> action) {
        Function<Throwable, Uni<?>> actual = Infrastructure.decorate(ParameterValidation.nonNull(action, "action"));
        return this.recoverWithMulti((? super Throwable failure) -> {
            Uni uni = (Uni)actual.apply((Throwable)failure);
            if (uni == null) {
                throw new NullPointerException("The `action` produced a `null` Uni");
            }
            return Multi.createFrom().emitter(emitter -> {
                Cancellable cancellable = uni.subscribe().with(success -> emitter.fail((Throwable)failure), subFailure -> emitter.fail(new CompositeException((Throwable)failure, (Throwable)subFailure)));
                emitter.onTermination(cancellable::cancel);
            });
        });
    }

    public Multi<T> call(Supplier<Uni<?>> action) {
        Supplier<Uni<?>> actual = Infrastructure.decorate(ParameterValidation.nonNull(action, "action"));
        return this.call((Throwable ignored) -> (Uni)actual.get());
    }

    @Deprecated
    public Multi<T> invokeUni(Function<Throwable, Uni<?>> action) {
        return this.call(action);
    }

    @Deprecated
    public Multi<T> apply(Function<? super Throwable, ? extends Throwable> mapper) {
        return this.transform(mapper);
    }

    public Multi<T> transform(Function<? super Throwable, ? extends Throwable> mapper) {
        Function<? super Throwable, ? extends Throwable> actual = Infrastructure.decorate(ParameterValidation.nonNull(mapper, "mapper"));
        return Infrastructure.onMultiCreation(new MultiOnFailureTransform<T>(this.upstream, this.predicate, actual));
    }

    public Multi<T> recoverWithItem(T fallback) {
        ParameterValidation.nonNull(fallback, "fallback");
        return this.recoverWithItem(() -> fallback);
    }

    public Multi<T> recoverWithItem(Supplier<T> supplier) {
        Supplier actual = Infrastructure.decorate(ParameterValidation.nonNull(supplier, "supplier"));
        return this.recoverWithItem((? super Throwable ignored) -> {
            Object t = actual.get();
            if (t == null) {
                throw new NullPointerException("The supplier returned `null`");
            }
            return t;
        });
    }

    public Multi<T> recoverWithItem(Function<? super Throwable, ? extends T> function) {
        Function actual = Infrastructure.decorate(ParameterValidation.nonNull(function, "function"));
        return Infrastructure.onMultiCreation(new MultiFlatMapOnFailure(this.upstream, this.predicate, failure -> {
            Object newResult = actual.apply((Throwable)failure);
            return Multi.createFrom().item(newResult);
        }));
    }

    public Multi<T> recoverWithCompletion() {
        return this.recoverWithMulti(Multi.createFrom().empty());
    }

    public Multi<T> recoverWithMulti(Function<? super Throwable, Multi<? extends T>> function) {
        Function<? super Throwable, Multi<? extends T>> actual = Infrastructure.decorate(ParameterValidation.nonNull(function, "function"));
        return Infrastructure.onMultiCreation(new MultiFlatMapOnFailure<T>(this.upstream, this.predicate, actual));
    }

    public Multi<T> recoverWithMulti(Supplier<Multi<? extends T>> supplier) {
        Supplier actual = Infrastructure.decorate(ParameterValidation.nonNull(supplier, "supplier"));
        return this.recoverWithMulti((? super Throwable ignored) -> (Multi)actual.get());
    }

    public Multi<T> recoverWithMulti(Multi<? extends T> fallback) {
        return this.recoverWithMulti(() -> fallback);
    }

    public MultiRetry<T> retry() {
        return new MultiRetry<T>(this.upstream, this.predicate);
    }
}

