/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.builders.ResourceMulti;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;

public class MultiResource<R, I> {
    private final Function<? super R, ? extends Publisher<I>> streamSupplier;
    private final Supplier<? extends R> resourceSupplier;

    public MultiResource(Supplier<? extends R> resourceSupplier, Function<? super R, ? extends Publisher<I>> streamSupplier) {
        this.resourceSupplier = resourceSupplier;
        this.streamSupplier = streamSupplier;
    }

    public Multi<I> withFinalizer(Consumer<? super R> finalizer) {
        Consumer callback = Infrastructure.decorate(ParameterValidation.nonNull(finalizer, "finalizer"));
        Function<Object, Uni> actual = r -> {
            callback.accept((Object)r);
            return Uni.createFrom().voidItem();
        };
        return this.withFinalizer(actual, (r, ignored) -> (Uni)actual.apply(r), actual);
    }

    public Multi<I> withFinalizer(Function<? super R, Uni<Void>> finalizer) {
        Function actual = Infrastructure.decorate(ParameterValidation.nonNull(finalizer, "finalizer"));
        return this.withFinalizer(actual, (r, ignored) -> (Uni)actual.apply((Object)r), actual);
    }

    public Multi<I> withFinalizer(Function<? super R, Uni<Void>> onCompletion, BiFunction<? super R, ? super Throwable, Uni<Void>> onFailure, Function<? super R, Uni<Void>> onCancellation) {
        Function<? super R, Uni<Void>> actualOnCompletion = Infrastructure.decorate(ParameterValidation.nonNull(onCompletion, "onCompletion"));
        BiFunction<? super R, ? super Throwable, Uni<Void>> actualOnFailure = Infrastructure.decorate(ParameterValidation.nonNull(onFailure, "onFailure"));
        Function<? super R, Uni<Void>> actualOnCancellation = Infrastructure.decorate(ParameterValidation.nonNull(onCancellation, "onCancellation"));
        return new ResourceMulti(this.resourceSupplier, this.streamSupplier, actualOnCompletion, actualOnFailure, actualOnCancellation);
    }
}

