/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.core;

import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.reactive.streams.operators.CompletionSubscriber;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;
import org.eclipse.microprofile.reactive.streams.operators.core.ReactiveStreamsEngineResolver;
import org.eclipse.microprofile.reactive.streams.operators.core.ReactiveStreamsGraphBuilder;
import org.eclipse.microprofile.reactive.streams.operators.spi.ReactiveStreamsEngine;
import org.eclipse.microprofile.reactive.streams.operators.spi.Stage;
import org.eclipse.microprofile.reactive.streams.operators.spi.SubscriberWithCompletionStage;
import org.reactivestreams.Subscriber;

public final class SubscriberBuilderImpl<T, R>
extends ReactiveStreamsGraphBuilder
implements SubscriberBuilder<T, R> {
    SubscriberBuilderImpl(Stage stage, ReactiveStreamsGraphBuilder previous) {
        super(stage, previous);
    }

    public CompletionSubscriber<T, R> build() {
        return this.build(ReactiveStreamsEngineResolver.instance());
    }

    public CompletionSubscriber<T, R> build(ReactiveStreamsEngine engine) {
        Objects.requireNonNull(engine, "Engine must not be null");
        SubscriberWithCompletionStage subscriberWithCompletionStage = engine.buildSubscriber(this.toGraph());
        return CompletionSubscriber.of((Subscriber)subscriberWithCompletionStage.getSubscriber(), (CompletionStage)subscriberWithCompletionStage.getCompletion());
    }
}

