/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import javax.management.MBeanServer;
import org.jgroups.blocks.Cache;
import org.jgroups.blocks.MemcachedConnector;
import org.jgroups.blocks.PartitionedHashMap;
import org.jgroups.jmx.JmxConfigurator;

public class MemcachedServer {
    private MemcachedConnector connector;
    private PartitionedHashMap<String, byte[]> cache;
    private static final String BASENAME = "memcached";

    private void start(String props, InetAddress bind_addr, int port, int min_threads, int max_threads, long rpc_timeout, long caching_time, boolean migrate_data, boolean use_l1_cache, int l1_max_entries, long l1_reaping_interval, int l2_max_entries, long l2_reaping_interval) throws Exception {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        this.connector = new MemcachedConnector(bind_addr, port, null);
        this.connector.setThreadPoolCoreThreads(min_threads);
        this.connector.setThreadPoolMaxThreads(max_threads);
        JmxConfigurator.register(this.connector, server, "memcached:name=connector");
        this.cache = new PartitionedHashMap(props, "memcached-cluster");
        this.cache.setCallTimeout(rpc_timeout);
        this.cache.setCachingTime(caching_time);
        this.cache.setMigrateData(migrate_data);
        JmxConfigurator.register(this.cache, server, "memcached:name=cache");
        JmxConfigurator.register(this.cache.getL2Cache(), server, "memcached:name=l2-cache");
        if (use_l1_cache) {
            Cache l1_cache = new Cache();
            this.cache.setL1Cache(l1_cache);
            if (l1_reaping_interval > 0L) {
                l1_cache.enableReaping(l1_reaping_interval);
            }
            if (l1_max_entries > 0) {
                l1_cache.setMaxNumberOfEntries(l1_max_entries);
            }
            JmxConfigurator.register(this.cache.getL1Cache(), server, "memcached:name=l1-cache");
        }
        if (l2_max_entries > 0 || l2_reaping_interval > 0L) {
            Cache<String, byte[]> l2_cache = this.cache.getL2Cache();
            if (l2_max_entries > 0) {
                l2_cache.setMaxNumberOfEntries(l2_max_entries);
            }
            if (l2_reaping_interval > 0L) {
                l2_cache.enableReaping(l2_reaping_interval);
            }
        }
        this.connector.setCache(this.cache);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                MemcachedServer.this.cache.stop();
                try {
                    MemcachedServer.this.connector.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.cache.start();
        this.connector.start();
    }

    public static void main(String[] args) throws Exception {
        InetAddress bind_addr = null;
        int port = 11211;
        String props = "udp.xml";
        int min_threads = 1;
        int max_threads = 500;
        long rpc_timeout = 1500L;
        long caching_time = 30000L;
        boolean migrate_data = true;
        boolean use_l1_cache = true;
        int l1_max_entries = 5000;
        int l2_max_entries = -1;
        long l1_reaping_interval = -1L;
        long l2_reaping_interval = 30000L;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-bind_addr")) {
                bind_addr = InetAddress.getByName(args[++i]);
                continue;
            }
            if (args[i].equals("-port") || args[i].equals("-p")) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-props")) {
                props = args[++i];
                continue;
            }
            if (args[i].equals("-min_threads")) {
                min_threads = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-max_threads")) {
                max_threads = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-rpc_timeout")) {
                rpc_timeout = Long.parseLong(args[++i]);
                continue;
            }
            if (args[i].equals("-caching_time")) {
                caching_time = Long.parseLong(args[++i]);
                continue;
            }
            if (args[i].equals("-migrate_data")) {
                migrate_data = Boolean.parseBoolean(args[++i]);
                continue;
            }
            if (args[i].equals("-use_l1_cache")) {
                use_l1_cache = Boolean.parseBoolean(args[++i]);
                continue;
            }
            if (args[i].equals("-l1_max_entries")) {
                l1_max_entries = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-l1_reaping_interval")) {
                l1_reaping_interval = Long.parseLong(args[++i]);
                continue;
            }
            if (args[i].equals("-l2_max_entries")) {
                l2_max_entries = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-l2_reaping_interval")) {
                l2_reaping_interval = Long.parseLong(args[++i]);
                continue;
            }
            MemcachedServer.help();
            return;
        }
        new MemcachedServer().start(props, bind_addr, port, min_threads, max_threads, rpc_timeout, caching_time, migrate_data, use_l1_cache, l1_max_entries, l1_reaping_interval, l2_max_entries, l2_reaping_interval);
    }

    private static void help() {
        System.out.println("MemcachedServer [-help] [-bind_addr <address>] [-port <port>] [-props <props>] [-min_threads <min>] [-max_threads <max>] [-rpc_timeout <ms>] [-caching_time <ms>] [-migrate_data <true|false>] [-use_l1_cache <true|false>] [-l1_max_entries <num>] [-l1_reaping_interval <ms>] [-l2_max_entries <num>] [-l2_reaping_interval <ms>] ");
    }
}

