/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus.impl.clustered;

import io.netty.channel.EventLoop;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.eventbus.Message;
import io.vertx.core.impl.ContextInternal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;

public class Serializer {
    private final ContextInternal context;
    private final Map<String, SerializerQueue> queues;

    private Serializer(ContextInternal context) {
        this.context = context;
        this.queues = new HashMap<String, SerializerQueue>();
        if (context.isDeployment()) {
            context.addCloseHook(this::close);
        }
    }

    public static Serializer get(ContextInternal context) {
        ConcurrentMap<Object, Object> contextData = context.contextData();
        Serializer serializer = (Serializer)contextData.get(Serializer.class);
        if (serializer == null) {
            Serializer candidate = new Serializer(context);
            Serializer previous = (Serializer)contextData.putIfAbsent(Serializer.class, candidate);
            serializer = previous == null ? candidate : previous;
        }
        return serializer;
    }

    public <T> void queue(Message<?> message, BiConsumer<Message<?>, Promise<T>> selectHandler, Promise<T> promise) {
        EventLoop eventLoop = this.context.nettyEventLoop();
        if (eventLoop.inEventLoop()) {
            String address = message.address();
            SerializerQueue queue = this.queues.computeIfAbsent(address, x$0 -> new SerializerQueue((String)x$0));
            queue.add(message, selectHandler, promise);
        } else {
            eventLoop.execute(() -> this.queue(message, selectHandler, promise));
        }
    }

    private void close(Promise<Void> promise) {
        this.queues.forEach((address, queue) -> queue.close());
        promise.complete();
    }

    private class SerializerQueue {
        private final Queue<SerializedTask<?>> tasks;
        private final String address;
        private boolean running;
        private boolean closed;

        SerializerQueue(String address) {
            this.address = address;
            this.tasks = new LinkedList();
        }

        void checkPending() {
            if (!this.running) {
                block2: {
                    SerializedTask<?> task;
                    this.running = true;
                    while ((task = this.tasks.peek()) != null) {
                        task.process();
                        if (this.tasks.peek() != task) continue;
                        break block2;
                    }
                    Serializer.this.queues.remove(this.address);
                }
                this.running = false;
            }
        }

        <U> void add(Message<?> msg, BiConsumer<Message<?>, Promise<U>> selectHandler, Promise<U> promise) {
            SerializedTask<U> serializedTask = new SerializedTask<U>(Serializer.this.context, msg, selectHandler);
            Future fut = serializedTask.internalPromise.future();
            fut.onComplete(promise);
            fut.onComplete(serializedTask);
            this.tasks.add(serializedTask);
            this.checkPending();
        }

        void processed() {
            if (!this.closed) {
                this.tasks.poll();
                this.checkPending();
            }
        }

        void close() {
            this.closed = true;
            while (!this.tasks.isEmpty()) {
                this.tasks.remove().internalPromise.tryFail("Context is closing");
            }
        }

        private class SerializedTask<U>
        implements Handler<AsyncResult<U>> {
            final Message<?> msg;
            final BiConsumer<Message<?>, Promise<U>> selectHandler;
            final Promise<U> internalPromise;

            SerializedTask(ContextInternal context, Message<?> msg, BiConsumer<Message<?>, Promise<U>> selectHandler) {
                this.msg = msg;
                this.selectHandler = selectHandler;
                this.internalPromise = context.promise();
            }

            void process() {
                this.selectHandler.accept(this.msg, this.internalPromise);
            }

            @Override
            public void handle(AsyncResult<U> ar) {
                SerializerQueue.this.processed();
            }
        }
    }
}

