/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import java.util.function.Function;

public class CloseFuture
implements Future<Void>,
Closeable {
    private final Promise<Void> promise = Promise.promise();
    private Closeable resource;
    private boolean closed;

    public CloseFuture() {
    }

    public CloseFuture(Closeable resource) {
        this.resource = resource;
    }

    public synchronized void init(Closeable closeable) {
        if (this.closed) {
            throw new IllegalStateException();
        }
        this.resource = closeable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Promise<Void> promise) {
        Closeable resource;
        boolean close;
        CloseFuture closeFuture = this;
        synchronized (closeFuture) {
            close = !this.closed;
            resource = this.resource;
            this.closed = true;
        }
        if (resource == null) {
            promise.fail("Close future not initialized");
        } else if (close) {
            resource.close(promise);
            promise.future().onComplete(this.promise);
        } else {
            this.promise.future().onComplete(promise);
        }
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isComplete() {
        return this.promise.future().isComplete();
    }

    @Override
    public Future<Void> onComplete(Handler<AsyncResult<Void>> handler) {
        this.promise.future().onComplete(handler);
        return this;
    }

    @Override
    public Void result() {
        return this.promise.future().result();
    }

    @Override
    public Throwable cause() {
        return this.promise.future().cause();
    }

    @Override
    public boolean succeeded() {
        return this.promise.future().succeeded();
    }

    @Override
    public boolean failed() {
        return this.promise.future().failed();
    }

    @Override
    public <U> Future<U> compose(Function<Void, Future<U>> successMapper, Function<Throwable, Future<U>> failureMapper) {
        return this.promise.future().compose(successMapper, failureMapper);
    }

    @Override
    public <U> Future<Void> eventually(Function<Void, Future<U>> mapper) {
        return this.promise.future().eventually(mapper);
    }

    @Override
    public <U> Future<U> transform(Function<AsyncResult<Void>, Future<U>> mapper) {
        return this.promise.future().transform(mapper);
    }

    @Override
    public <U> Future<U> map(Function<Void, U> mapper) {
        return this.promise.future().map((Function)mapper);
    }

    @Override
    public <V> Future<V> map(V value) {
        return this.promise.future().map((Object)value);
    }

    @Override
    public Future<Void> otherwise(Function<Throwable, Void> mapper) {
        return this.promise.future().otherwise((Function)mapper);
    }

    @Override
    public Future<Void> otherwise(Void value) {
        return this.promise.future().otherwise((Object)value);
    }
}

