/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.future;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.core.impl.future.FutureBase;
import io.vertx.core.impl.future.Listener;
import java.util.ArrayList;
import java.util.Objects;

class FutureImpl<T>
extends FutureBase<T> {
    private static final Object NULL_VALUE = new Object();
    private Object value;
    private Listener<T> listener;

    FutureImpl() {
    }

    FutureImpl(ContextInternal context) {
        super(context);
    }

    @Override
    public synchronized T result() {
        return (T)(this.value instanceof Throwable ? null : (this.value == NULL_VALUE ? null : this.value));
    }

    @Override
    public synchronized Throwable cause() {
        return this.value instanceof Throwable ? (Throwable)this.value : null;
    }

    @Override
    public synchronized boolean succeeded() {
        return this.value != null && !(this.value instanceof Throwable);
    }

    @Override
    public synchronized boolean failed() {
        return this.value instanceof Throwable;
    }

    @Override
    public synchronized boolean isComplete() {
        return this.value != null;
    }

    @Override
    public Future<T> onSuccess(final Handler<T> handler) {
        Objects.requireNonNull(handler, "No null handler accepted");
        this.addListener(new Listener<T>(){

            @Override
            public void onSuccess(T value) {
                handler.handle(value);
            }

            @Override
            public void onFailure(Throwable failure) {
            }
        });
        return this;
    }

    @Override
    public Future<T> onFailure(final Handler<Throwable> handler) {
        Objects.requireNonNull(handler, "No null handler accepted");
        this.addListener(new Listener<T>(){

            @Override
            public void onSuccess(T value) {
            }

            @Override
            public void onFailure(Throwable failure) {
                handler.handle(failure);
            }
        });
        return this;
    }

    @Override
    public Future<T> onComplete(final Handler<AsyncResult<T>> handler) {
        Objects.requireNonNull(handler, "No null handler accepted");
        Listener listener = handler instanceof Listener ? (Listener)handler : new Listener<T>(){

            @Override
            public void onSuccess(T value) {
                handler.handle(FutureImpl.this);
            }

            @Override
            public void onFailure(Throwable failure) {
                handler.handle(FutureImpl.this);
            }
        };
        this.addListener(listener);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(Listener<T> listener) {
        Object v;
        FutureImpl futureImpl = this;
        synchronized (futureImpl) {
            v = this.value;
            if (v == null) {
                if (this.listener == null) {
                    this.listener = listener;
                } else {
                    ListenerArray listeners;
                    if (this.listener instanceof ListenerArray) {
                        listeners = (ListenerArray)this.listener;
                    } else {
                        listeners = new ListenerArray();
                        listeners.add(this.listener);
                        this.listener = listeners;
                    }
                    listeners.add(listener);
                }
                return;
            }
        }
        if (v instanceof Throwable) {
            this.emitFailure((Throwable)v, listener);
        } else {
            if (v == NULL_VALUE) {
                v = null;
            }
            this.emitSuccess(v, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryComplete(T result) {
        Listener<T> l;
        FutureImpl futureImpl = this;
        synchronized (futureImpl) {
            if (this.value != null) {
                return false;
            }
            this.value = result == null ? NULL_VALUE : result;
            l = this.listener;
            this.listener = null;
        }
        if (l != null) {
            this.emitSuccess(result, l);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryFail(Throwable cause) {
        Listener<T> l;
        if (cause == null) {
            cause = new NoStackTraceThrowable(null);
        }
        FutureImpl futureImpl = this;
        synchronized (futureImpl) {
            if (this.value != null) {
                return false;
            }
            this.value = cause;
            l = this.listener;
            this.listener = null;
        }
        if (l != null) {
            this.emitFailure(cause, l);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        FutureImpl futureImpl = this;
        synchronized (futureImpl) {
            if (this.value instanceof Throwable) {
                return "Future{cause=" + ((Throwable)this.value).getMessage() + "}";
            }
            if (this.value != null) {
                if (this.value == NULL_VALUE) {
                    return "Future{result=null}";
                }
                StringBuilder sb = new StringBuilder("Future{result=");
                this.formatValue(this.value, sb);
                sb.append("}");
                return sb.toString();
            }
            return "Future{unresolved}";
        }
    }

    protected void formatValue(Object value, StringBuilder sb) {
        sb.append(value);
    }

    private static class ListenerArray<T>
    extends ArrayList<Listener<T>>
    implements Listener<T> {
        private ListenerArray() {
        }

        @Override
        public void onSuccess(T value) {
            for (Listener handler : this) {
                handler.onSuccess(value);
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            for (Listener handler : this) {
                handler.onFailure(failure);
            }
        }
    }
}

