/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.SearchConfigurationBase;
import org.hibernate.search.engine.service.classloading.spi.ClassLoaderService;
import org.hibernate.search.engine.service.spi.Service;
import org.hibernate.search.spi.InstanceInitializer;
import org.hibernate.search.spi.impl.SearchFactoryState;

public class IncrementalSearchConfiguration
extends SearchConfigurationBase {
    private final List<Class<?>> classes;
    private final Map<String, Class<?>> classesByName = new HashMap();
    private final SearchFactoryState searchFactoryState;
    private final Properties properties;
    private final ReflectionManager reflectionManager = new JavaReflectionManager();

    public IncrementalSearchConfiguration(List<Class<?>> classes, Properties properties, SearchFactoryState factoryState) {
        this.properties = properties;
        this.classes = classes;
        this.searchFactoryState = factoryState;
        for (Class<?> entity : classes) {
            this.classesByName.put(entity.getName(), entity);
        }
    }

    @Override
    public Iterator<Class<?>> getClassMappings() {
        return this.classes.iterator();
    }

    @Override
    public Class<?> getClassMapping(String name) {
        return this.classesByName.get(name);
    }

    @Override
    public String getProperty(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public ReflectionManager getReflectionManager() {
        return this.reflectionManager;
    }

    @Override
    public SearchMapping getProgrammaticMapping() {
        return this.searchFactoryState.getProgrammaticMapping();
    }

    @Override
    public Map<Class<? extends Service>, Object> getProvidedServices() {
        return Collections.emptyMap();
    }

    @Override
    public boolean isTransactionManagerExpected() {
        return this.searchFactoryState.isTransactionManagerExpected();
    }

    @Override
    public InstanceInitializer getInstanceInitializer() {
        return this.searchFactoryState.getInstanceInitializer();
    }

    @Override
    public boolean isIndexMetadataComplete() {
        return this.searchFactoryState.isIndexMetadataComplete();
    }

    @Override
    public boolean isDeleteByTermEnforced() {
        return this.searchFactoryState.isDeleteByTermEnforced();
    }

    @Override
    public boolean isIdProvidedImplicit() {
        return this.searchFactoryState.isIdProvidedImplicit();
    }

    @Override
    public ClassLoaderService getClassLoaderService() {
        return this.searchFactoryState.getServiceManager().getClassLoaderService();
    }
}

