/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.engine.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.range.DoubleRange;
import org.apache.lucene.facet.range.DoubleRangeFacetCounts;
import org.apache.lucene.facet.range.LongRange;
import org.apache.lucene.facet.range.LongRangeFacetCounts;
import org.apache.lucene.facet.sortedset.DefaultSortedSetDocValuesReaderState;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesFacetCounts;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesReaderState;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TimeLimitingCollector;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Counter;
import org.hibernate.search.engine.metadata.impl.FacetMetadata;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.dsl.impl.DiscreteFacetRequest;
import org.hibernate.search.query.dsl.impl.FacetRange;
import org.hibernate.search.query.dsl.impl.RangeFacetRequest;
import org.hibernate.search.query.engine.impl.FacetComparators;
import org.hibernate.search.query.engine.impl.LazyQueryState;
import org.hibernate.search.query.engine.impl.QueryFilters;
import org.hibernate.search.query.engine.impl.TimeoutManagerImpl;
import org.hibernate.search.query.engine.spi.TimeoutManager;
import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.query.facet.FacetSortOrder;
import org.hibernate.search.query.facet.FacetingRequest;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.impl.DistanceCollector;
import org.hibernate.search.util.impl.ReflectionHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class QueryHits {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private static final int DEFAULT_TOP_DOC_RETRIEVAL_SIZE = 100;
    private final LazyQueryState searcher;
    private final QueryFilters filters;
    private final Sort sort;
    private final boolean collectHits;
    private final Map<FacetingRequest, FacetMetadata> facetingRequestsAndMetadata;
    private final TimeoutManagerImpl timeoutManager;
    private int totalHits;
    private TopDocs topDocs;
    private Map<String, List<Facet>> facetMap;
    private FacetsCollector facetsCollector;
    private DistanceCollector distanceCollector = null;
    private Coordinates spatialSearchCenter = null;
    private String spatialFieldName = null;

    public QueryHits(LazyQueryState searcher, QueryFilters filters, Sort sort, boolean collectHits, TimeoutManagerImpl timeoutManager, Map<FacetingRequest, FacetMetadata> facetingRequestsAndMetadata, Coordinates spatialSearchCenter, String spatialFieldName) throws IOException {
        this(searcher, filters, sort, 100, collectHits, timeoutManager, facetingRequestsAndMetadata, spatialSearchCenter, spatialFieldName);
    }

    public QueryHits(LazyQueryState searcher, QueryFilters filters, Sort sort, Integer n, boolean collectHits, TimeoutManagerImpl timeoutManager, Map<FacetingRequest, FacetMetadata> facetingRequestsAndMetadata, Coordinates spatialSearchCenter, String spatialFieldName) throws IOException {
        this.timeoutManager = timeoutManager;
        this.searcher = searcher;
        this.filters = filters;
        this.sort = sort;
        this.collectHits = collectHits;
        this.facetingRequestsAndMetadata = facetingRequestsAndMetadata;
        this.spatialSearchCenter = spatialSearchCenter;
        this.spatialFieldName = spatialFieldName;
        this.updateTopDocs(n);
    }

    public Document doc(int index) throws IOException {
        return this.searcher.doc(this.docId(index));
    }

    public void visitDocument(int index, StoredFieldVisitor fieldVisitor) throws IOException {
        this.searcher.doc(this.docId(index), fieldVisitor);
    }

    public ScoreDoc scoreDoc(int index) throws IOException {
        if (index >= this.totalHits) {
            throw new SearchException("Not a valid ScoreDoc index: " + index);
        }
        if (index >= this.topDocs.scoreDocs.length) {
            this.updateTopDocs(2 * index);
        }
        return this.topDocs.scoreDocs[index];
    }

    public int docId(int index) throws IOException {
        return this.scoreDoc((int)index).doc;
    }

    public float score(int index) throws IOException {
        return this.scoreDoc((int)index).score;
    }

    public Double spatialDistance(int index) throws IOException {
        if (this.spatialSearchCenter == null) {
            return null;
        }
        return this.distanceCollector.getDistance(this.docId(index));
    }

    public Explanation explain(int index) throws IOException {
        Explanation explanation = this.searcher.explain(this.filters, this.docId(index));
        this.timeoutManager.isTimedOut();
        return explanation;
    }

    public int getTotalHits() {
        return this.totalHits;
    }

    public TopDocs getTopDocs() {
        return this.topDocs;
    }

    public Map<String, List<Facet>> getFacets() {
        if (this.facetingRequestsAndMetadata == null || this.facetingRequestsAndMetadata.size() == 0) {
            return Collections.emptyMap();
        }
        return this.facetMap;
    }

    private void updateTopDocs(int n) throws IOException {
        TotalHitCountCollector collector;
        TotalHitCountCollector hitCountCollector;
        TotalHitCountCollector topDocCollector;
        boolean collectTopDocs;
        int totalMaxDocs = this.searcher.maxDoc();
        int maxDocs = Math.min(n, totalMaxDocs);
        boolean bl = collectTopDocs = this.collectHits && maxDocs != 0;
        if (collectTopDocs) {
            topDocCollector = this.createTopDocCollector(maxDocs);
            hitCountCollector = null;
            collector = topDocCollector;
            collector = this.optionallyEnableFacetingCollector((Collector)collector);
            collector = this.optionallyEnableDistanceCollector((Collector)collector, maxDocs);
        } else {
            topDocCollector = null;
            collector = hitCountCollector = new TotalHitCountCollector();
        }
        collector = this.decorateWithTimeOutCollector((Collector)collector);
        boolean timeoutNow = this.isImmediateTimeout();
        if (!timeoutNow) {
            try {
                this.searcher.search(this.filters, (Collector)collector);
            }
            catch (TimeLimitingCollector.TimeExceededException e) {
                this.timeoutManager.forceTimedOut();
            }
        }
        if (collectTopDocs) {
            this.topDocs = topDocCollector.topDocs();
            this.totalHits = this.topDocs.totalHits;
        } else {
            this.topDocs = null;
            this.totalHits = hitCountCollector.getTotalHits();
        }
        if (this.collectHits && this.facetingRequestsAndMetadata != null && !this.facetingRequestsAndMetadata.isEmpty()) {
            this.updateFacets();
        }
        this.timeoutManager.isTimedOut();
    }

    private void updateFacets() throws IOException {
        this.facetMap = new HashMap<String, List<Facet>>();
        for (Map.Entry<FacetingRequest, FacetMetadata> entry : this.facetingRequestsAndMetadata.entrySet()) {
            int maxNumberOfExpectedFacets;
            FacetingRequest facetRequest = entry.getKey();
            FacetMetadata facetMetadata = entry.getValue();
            ArrayList<Facet> facets = facetRequest instanceof DiscreteFacetRequest ? this.updateStringFacets((DiscreteFacetRequest)facetRequest, facetMetadata) : this.updateRangeFacets((RangeFacetRequest)facetRequest, facetMetadata);
            if (!facetRequest.getSort().equals((Object)FacetSortOrder.RANGE_DEFINITION_ORDER)) {
                Collections.sort(facets, FacetComparators.get(facetRequest.getSort()));
            }
            if ((maxNumberOfExpectedFacets = facetRequest.getMaxNumberOfFacets()) > 0 && facets.size() > maxNumberOfExpectedFacets) {
                facets = new ArrayList<Facet>(facets.subList(0, facetRequest.getMaxNumberOfFacets()));
            }
            this.facetMap.put(facetRequest.getFacetingName(), facets);
        }
    }

    private ArrayList<Facet> updateRangeFacets(RangeFacetRequest<?> facetRequest, FacetMetadata facetMetadata) throws IOException {
        ArrayList<Facet> facets;
        if (ReflectionHelper.isIntegerType(facetRequest.getFacetValueType()) || Date.class.isAssignableFrom(facetRequest.getFacetValueType())) {
            FacetResult facetResult = this.getFacetResultForLongRange(facetRequest);
            facets = new ArrayList<Facet>(facetResult.labelValues.length);
            for (LabelAndValue labelAndValue : facetResult.labelValues) {
                if (!facetRequest.hasZeroCountsIncluded() && (Integer)labelAndValue.value == 0) continue;
                Facet facet = facetRequest.createFacet(facetMetadata, labelAndValue.label, (Integer)labelAndValue.value);
                facets.add(facet);
            }
        } else if (ReflectionHelper.isFloatingPointType(facetRequest.getFacetValueType())) {
            FacetResult facetResult = this.getFacetResultForFloatingPointRange(facetRequest);
            facets = new ArrayList(facetResult.labelValues.length);
            for (LabelAndValue labelAndValue : facetResult.labelValues) {
                if (!facetRequest.hasZeroCountsIncluded() && (Integer)labelAndValue.value == 0) continue;
                Facet facet = facetRequest.createFacet(facetMetadata, labelAndValue.label, (Integer)labelAndValue.value);
                facets.add(facet);
            }
        } else {
            throw log.unsupportedFacetRangeParameter(facetRequest.getFacetValueType().getName());
        }
        return facets;
    }

    private FacetResult getFacetResultForFloatingPointRange(RangeFacetRequest<?> facetRequest) throws IOException {
        List<FacetRange<?>> facetRanges = facetRequest.getFacetRangeList();
        DoubleRange[] ranges = new DoubleRange[facetRanges.size()];
        int i = 0;
        for (FacetRange<?> facetRange : facetRanges) {
            ranges[i] = new DoubleRange(facetRange.getRangeString(), facetRange.getMin() == null ? Double.MIN_VALUE : ((Number)facetRange.getMin()).doubleValue(), facetRange.isMinIncluded(), facetRange.getMax() == null ? Double.MAX_VALUE : ((Number)facetRange.getMax()).doubleValue(), facetRange.isMaxIncluded());
            ++i;
        }
        DoubleRangeFacetCounts facetCount = new DoubleRangeFacetCounts(facetRequest.getFieldName(), this.facetsCollector != null ? this.facetsCollector : new FacetsCollector(), ranges);
        return facetCount.getTopChildren(facetRequest.getMaxNumberOfFacets(), facetRequest.getFieldName(), new String[0]);
    }

    private FacetResult getFacetResultForLongRange(RangeFacetRequest<?> facetRequest) throws IOException {
        List<FacetRange<?>> facetRanges = facetRequest.getFacetRangeList();
        LongRange[] ranges = new LongRange[facetRanges.size()];
        int i = 0;
        for (FacetRange<?> facetRange : facetRanges) {
            long max;
            long min;
            if (ReflectionHelper.isIntegerType(facetRequest.getFacetValueType())) {
                min = facetRange.getMin() == null ? Long.MIN_VALUE : ((Number)facetRange.getMin()).longValue();
                max = facetRange.getMax() == null ? Long.MAX_VALUE : ((Number)facetRange.getMax()).longValue();
            } else {
                min = facetRange.getMin() == null ? Long.MIN_VALUE : ((Date)facetRange.getMin()).getTime();
                max = facetRange.getMax() == null ? Long.MAX_VALUE : ((Date)facetRange.getMax()).getTime();
            }
            ranges[i] = new LongRange(facetRange.getRangeString(), min, facetRange.isMinIncluded(), max, facetRange.isMaxIncluded());
            ++i;
        }
        LongRangeFacetCounts facetCount = new LongRangeFacetCounts(facetRequest.getFieldName(), this.facetsCollector != null ? this.facetsCollector : new FacetsCollector(), ranges);
        return facetCount.getTopChildren(facetRequest.getMaxNumberOfFacets(), facetRequest.getFieldName(), new String[0]);
    }

    private ArrayList<Facet> updateStringFacets(DiscreteFacetRequest facetRequest, FacetMetadata facetMetadata) throws IOException {
        FacetResult facetResult;
        DefaultSortedSetDocValuesReaderState docValuesReaderState;
        ArrayList<Facet> facets = new ArrayList<Facet>();
        try {
            docValuesReaderState = new DefaultSortedSetDocValuesReaderState(this.searcher.getIndexReader());
        }
        catch (IllegalArgumentException e) {
            return facets;
        }
        SortedSetDocValuesFacetCounts facetCounts = new SortedSetDocValuesFacetCounts((SortedSetDocValuesReaderState)docValuesReaderState, this.facetsCollector != null ? this.facetsCollector : new FacetsCollector());
        Set<Object> termValues = Collections.emptySet();
        if (facetRequest.hasZeroCountsIncluded()) {
            termValues = this.findAllTermsForField(facetMetadata.getSourceField().getAbsoluteName(), this.searcher.getIndexReader());
        }
        int maxFacetCount = facetRequest.getMaxNumberOfFacets() < 0 ? 100 : facetRequest.getMaxNumberOfFacets();
        try {
            facetResult = facetCounts.getTopChildren(maxFacetCount, facetRequest.getFieldName(), new String[0]);
        }
        catch (IllegalArgumentException e) {
            return facets;
        }
        if (facetResult != null) {
            for (LabelAndValue labelAndValue : facetResult.labelValues) {
                Facet facet = facetRequest.createFacet(facetMetadata, labelAndValue.label, (Integer)labelAndValue.value);
                facets.add(facet);
                termValues.remove(labelAndValue.label);
            }
        }
        for (String string : termValues) {
            Facet facet = facetRequest.createFacet(facetMetadata, string, 0);
            facets.add(0, facet);
        }
        return facets;
    }

    private Set<String> findAllTermsForField(String fieldName, IndexReader reader) throws IOException {
        HashSet<String> termValues = new HashSet<String>();
        for (LeafReaderContext leaf : reader.leaves()) {
            BytesRef byteRef;
            LeafReader atomicReader = leaf.reader();
            Terms terms = atomicReader.terms(fieldName);
            if (terms == null) continue;
            TermsEnum iterator = terms.iterator();
            while ((byteRef = iterator.next()) != null) {
                termValues.add(byteRef.utf8ToString());
            }
        }
        return termValues;
    }

    private Collector optionallyEnableFacetingCollector(Collector collector) {
        if (this.facetingRequestsAndMetadata == null || this.facetingRequestsAndMetadata.isEmpty()) {
            return collector;
        }
        this.facetsCollector = new FacetsCollector();
        return MultiCollector.wrap((Collector[])new Collector[]{this.facetsCollector, collector});
    }

    private Collector optionallyEnableDistanceCollector(Collector collector, int maxDocs) {
        if (this.spatialFieldName == null || this.spatialFieldName.isEmpty() || this.spatialSearchCenter == null) {
            return collector;
        }
        this.distanceCollector = new DistanceCollector(this.spatialSearchCenter, maxDocs, this.spatialFieldName);
        return MultiCollector.wrap((Collector[])new Collector[]{this.distanceCollector, collector});
    }

    private boolean isImmediateTimeout() {
        boolean timeoutAt0 = false;
        if (this.timeoutManager.getType() == TimeoutManager.Type.LIMIT) {
            Long timeoutLeft = this.timeoutManager.getTimeoutLeftInMilliseconds();
            if (timeoutLeft != null) {
                if (timeoutLeft == 0L && this.timeoutManager.isTimedOut()) {
                    this.timeoutManager.forceTimedOut();
                    timeoutAt0 = true;
                }
            } else if (this.timeoutManager.isTimedOut()) {
                this.timeoutManager.forceTimedOut();
            }
        }
        return timeoutAt0;
    }

    private Collector decorateWithTimeOutCollector(Collector collector) {
        Long timeoutLeft;
        Collector maybeTimeLimitingCollector = collector;
        if (this.timeoutManager.getType() == TimeoutManager.Type.LIMIT && (timeoutLeft = this.timeoutManager.getTimeoutLeftInMilliseconds()) != null) {
            Counter counter = this.timeoutManager.getLuceneTimeoutCounter();
            maybeTimeLimitingCollector = new TimeLimitingCollector(collector, counter, timeoutLeft.longValue());
        }
        return maybeTimeLimitingCollector;
    }

    private TopDocsCollector<?> createTopDocCollector(int maxDocs) throws IOException {
        TopScoreDocCollector topCollector;
        if (this.sort == null) {
            topCollector = TopScoreDocCollector.create((int)maxDocs);
        } else {
            boolean fillFields = true;
            topCollector = TopFieldCollector.create((Sort)this.sort, (int)maxDocs, (boolean)fillFields, (boolean)this.searcher.isFieldSortDoTrackScores(), (boolean)this.searcher.isFieldSortDoMaxScore());
        }
        return topCollector;
    }
}

