/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.service;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.management.MBeanServer;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.webservices.config.ServerConfigImpl;
import org.jboss.as.webservices.logging.WSLogger;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.wsf.spi.management.ServerConfig;
import org.wildfly.extension.undertow.UndertowService;

public final class ServerConfigService
implements Service {
    private static final ServiceName MBEAN_SERVER_NAME = ServiceName.JBOSS.append(new String[]{"mbean", "server"});
    private final ServerConfigImpl serverConfig;
    private final Consumer<ServerConfig> serverConfigConsumer;
    private final Supplier<MBeanServer> mBeanServerSupplier;
    private final Supplier<UndertowService> undertowServiceSupplier;
    private final Supplier<ServerEnvironment> serverEnvironmentSupplier;

    private ServerConfigService(ServerConfigImpl serverConfig, Consumer<ServerConfig> serverConfigConsumer, Supplier<MBeanServer> mBeanServerSupplier, Supplier<UndertowService> undertowServiceSupplier, Supplier<ServerEnvironment> serverEnvironmentSupplier) {
        this.serverConfig = serverConfig;
        this.serverConfigConsumer = serverConfigConsumer;
        this.mBeanServerSupplier = mBeanServerSupplier;
        this.undertowServiceSupplier = undertowServiceSupplier;
        this.serverEnvironmentSupplier = serverEnvironmentSupplier;
    }

    public void start(StartContext context) throws StartException {
        try {
            if (this.mBeanServerSupplier != null) {
                this.serverConfig.setMbeanServer(this.mBeanServerSupplier.get());
            }
            if (this.undertowServiceSupplier != null) {
                this.serverConfig.setUndertowService(this.undertowServiceSupplier.get());
            }
            this.serverConfig.setServerEnvironment(this.serverEnvironmentSupplier.get());
            this.serverConfig.create();
            this.serverConfigConsumer.accept((ServerConfig)this.serverConfig);
        }
        catch (Exception e) {
            WSLogger.ROOT_LOGGER.configServiceCreationFailed();
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext context) {
        try {
            this.serverConfig.destroy();
            if (this.mBeanServerSupplier != null) {
                this.serverConfig.setMbeanServer(null);
            }
            if (this.undertowServiceSupplier != null) {
                this.serverConfig.setUndertowService(null);
            }
        }
        catch (Exception e) {
            WSLogger.ROOT_LOGGER.configServiceDestroyFailed();
        }
    }

    public static ServiceController<?> install(ServiceTarget serviceTarget, ServerConfigImpl serverConfig, List<ServiceName> dependencies, boolean jmxSubsystemAvailable, boolean requireUndertow) {
        ServiceBuilder builder = serviceTarget.addService(WSServices.CONFIG_SERVICE);
        Consumer serverConfigConsumer = builder.provides(new ServiceName[]{WSServices.CONFIG_SERVICE});
        Supplier mBeanServerSupplier = jmxSubsystemAvailable ? builder.requires(MBEAN_SERVER_NAME) : null;
        Supplier undertowServiceSupplier = requireUndertow ? builder.requires(UndertowService.UNDERTOW) : null;
        Supplier serverEnvironmentSupplier = builder.requires(ServerEnvironmentService.SERVICE_NAME);
        for (ServiceName dep : dependencies) {
            builder.requires(dep);
        }
        builder.setInstance((Service)new ServerConfigService(serverConfig, serverConfigConsumer, mBeanServerSupplier, undertowServiceSupplier, serverEnvironmentSupplier));
        return builder.install();
    }
}

