/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.client.producer.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.kafka.client.common.KafkaClientOptions;
import io.vertx.kafka.client.common.PartitionInfo;
import io.vertx.kafka.client.common.impl.CloseHandler;
import io.vertx.kafka.client.common.impl.Helper;
import io.vertx.kafka.client.producer.KafkaProducer;
import io.vertx.kafka.client.producer.KafkaProducerRecord;
import io.vertx.kafka.client.producer.KafkaWriteStream;
import io.vertx.kafka.client.producer.RecordMetadata;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.serialization.Serializer;

public class KafkaProducerImpl<K, V>
implements KafkaProducer<K, V> {
    private static final Map<String, SharedProducer> sharedProducers = new HashMap<String, SharedProducer>();
    private final Vertx vertx;
    private final KafkaWriteStream<K, V> stream;
    private final CloseHandler closeHandler;

    public static <K, V> KafkaProducer<K, V> createShared(Vertx vertx, String name, Properties config) {
        return KafkaProducerImpl.createShared(vertx, name, () -> KafkaWriteStream.create(vertx, config));
    }

    public static <K, V> KafkaProducer<K, V> createShared(Vertx vertx, String name, Map<String, String> config) {
        return KafkaProducerImpl.createShared(vertx, name, () -> KafkaWriteStream.create(vertx, new HashMap<String, Object>(config)));
    }

    public static <K, V> KafkaProducer<K, V> createShared(Vertx vertx, String name, KafkaClientOptions options) {
        return KafkaProducerImpl.createShared(vertx, name, () -> KafkaWriteStream.create(vertx, options));
    }

    public static <K, V> KafkaProducer<K, V> createShared(Vertx vertx, String name, Properties config, Class<K> keyType, Class<V> valueType) {
        return KafkaProducerImpl.createShared(vertx, name, () -> KafkaWriteStream.create(vertx, config, keyType, valueType));
    }

    public static <K, V> KafkaProducer<K, V> createShared(Vertx vertx, String name, Properties config, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return KafkaProducerImpl.createShared(vertx, name, () -> KafkaWriteStream.create(vertx, config, keySerializer, valueSerializer));
    }

    public static <K, V> KafkaProducer<K, V> createShared(Vertx vertx, String name, Map<String, String> config, Class<K> keyType, Class<V> valueType) {
        return KafkaProducerImpl.createShared(vertx, name, () -> KafkaWriteStream.create(vertx, new HashMap<String, Object>(config), keyType, valueType));
    }

    public static <K, V> KafkaProducer<K, V> createShared(Vertx vertx, String name, Map<String, String> config, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return KafkaProducerImpl.createShared(vertx, name, () -> KafkaWriteStream.create(vertx, new HashMap<String, Object>(config), keySerializer, valueSerializer));
    }

    public static <K, V> KafkaProducer<K, V> createShared(Vertx vertx, String name, KafkaClientOptions options, Class<K> keyType, Class<V> valueType) {
        return KafkaProducerImpl.createShared(vertx, name, () -> KafkaWriteStream.create(vertx, options, keyType, valueType));
    }

    public static <K, V> KafkaProducer<K, V> createShared(Vertx vertx, String name, KafkaClientOptions options, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return KafkaProducerImpl.createShared(vertx, name, () -> KafkaWriteStream.create(vertx, options, keySerializer, valueSerializer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <K, V> KafkaProducer<K, V> createShared(Vertx vertx, String name, Supplier<KafkaWriteStream> streamFactory) {
        Map<String, SharedProducer> map = sharedProducers;
        synchronized (map) {
            SharedProducer sharedProducer = sharedProducers.computeIfAbsent(name, key -> {
                KafkaWriteStream stream = (KafkaWriteStream)streamFactory.get();
                SharedProducer s = new SharedProducer(stream);
                s.closeHandler.registerCloseHook((VertxInternal)vertx);
                return s;
            });
            Object key2 = new Object();
            KafkaProducerImpl producer = new KafkaProducerImpl(vertx, KafkaWriteStream.create(vertx, sharedProducer.producer), new CloseHandler((timeout, ar) -> {
                Map<String, SharedProducer> map = sharedProducers;
                synchronized (map) {
                    sharedProducer.remove(key2);
                    if (sharedProducer.isEmpty()) {
                        sharedProducers.remove(name);
                        sharedProducer.closeHandler.close((long)timeout, (Handler<AsyncResult<Void>>)ar);
                        return;
                    }
                }
                ar.handle((Object)Future.succeededFuture());
            }));
            sharedProducer.put(key2, producer);
            return producer.registerCloseHook();
        }
    }

    public KafkaProducerImpl(Vertx vertx, KafkaWriteStream<K, V> stream, CloseHandler closeHandler) {
        this.vertx = vertx;
        this.stream = stream;
        this.closeHandler = closeHandler;
    }

    public KafkaProducerImpl(Vertx vertx, KafkaWriteStream<K, V> stream) {
        this(vertx, stream, new CloseHandler(stream::close));
    }

    public KafkaProducerImpl<K, V> registerCloseHook() {
        Context context = Vertx.currentContext();
        if (context == null) {
            return this;
        }
        this.closeHandler.registerCloseHook((ContextInternal)context);
        return this;
    }

    @Override
    public KafkaProducer<K, V> initTransactions(Handler<AsyncResult<Void>> handler) {
        this.stream.initTransactions(handler);
        return this;
    }

    @Override
    public Future<Void> initTransactions() {
        return this.stream.initTransactions();
    }

    @Override
    public KafkaProducer<K, V> beginTransaction(Handler<AsyncResult<Void>> handler) {
        this.stream.beginTransaction(handler);
        return this;
    }

    @Override
    public Future<Void> beginTransaction() {
        return this.stream.beginTransaction();
    }

    @Override
    public KafkaProducer<K, V> commitTransaction(Handler<AsyncResult<Void>> handler) {
        this.stream.commitTransaction(handler);
        return this;
    }

    @Override
    public Future<Void> commitTransaction() {
        return this.stream.commitTransaction();
    }

    @Override
    public KafkaProducer<K, V> abortTransaction(Handler<AsyncResult<Void>> handler) {
        this.stream.abortTransaction(handler);
        return this;
    }

    @Override
    public Future<Void> abortTransaction() {
        return this.stream.abortTransaction();
    }

    @Override
    public KafkaProducer<K, V> exceptionHandler(Handler<Throwable> handler) {
        this.stream.exceptionHandler((Handler)handler);
        return this;
    }

    public Future<Void> write(KafkaProducerRecord<K, V> kafkaProducerRecord) {
        return this.stream.write(kafkaProducerRecord.record());
    }

    public void write(KafkaProducerRecord<K, V> record, Handler<AsyncResult<Void>> handler) {
        this.stream.write(record.record(), handler);
    }

    @Override
    public Future<RecordMetadata> send(KafkaProducerRecord<K, V> record) {
        return this.stream.send(record.record()).map(Helper::from);
    }

    @Override
    public KafkaProducer<K, V> send(KafkaProducerRecord<K, V> record, Handler<AsyncResult<RecordMetadata>> handler) {
        this.send(record).onComplete(handler);
        return this;
    }

    @Override
    public Future<List<PartitionInfo>> partitionsFor(String topic) {
        return this.stream.partitionsFor(topic).map(list -> list.stream().map(kafkaPartitionInfo -> new PartitionInfo().setInSyncReplicas(Stream.of(kafkaPartitionInfo.inSyncReplicas()).map(Helper::from).collect(Collectors.toList())).setLeader(Helper.from(kafkaPartitionInfo.leader())).setPartition(kafkaPartitionInfo.partition()).setReplicas(Stream.of(kafkaPartitionInfo.replicas()).map(Helper::from).collect(Collectors.toList())).setTopic(kafkaPartitionInfo.topic())).collect(Collectors.toList()));
    }

    @Override
    public KafkaProducer<K, V> partitionsFor(String topic, Handler<AsyncResult<List<PartitionInfo>>> handler) {
        this.partitionsFor(topic).onComplete(handler);
        return this;
    }

    public void end(Handler<AsyncResult<Void>> handler) {
        this.stream.end(handler);
    }

    @Override
    public KafkaProducer<K, V> setWriteQueueMaxSize(int size) {
        this.stream.setWriteQueueMaxSize(size);
        return this;
    }

    public boolean writeQueueFull() {
        return this.stream.writeQueueFull();
    }

    @Override
    public KafkaProducer<K, V> drainHandler(Handler<Void> handler) {
        this.stream.drainHandler((Handler)handler);
        return this;
    }

    @Override
    public KafkaProducer<K, V> flush(Handler<AsyncResult<Void>> completionHandler) {
        this.stream.flush(completionHandler);
        return this;
    }

    @Override
    public Future<Void> flush() {
        return this.stream.flush();
    }

    @Override
    public Future<Void> close(long timeout) {
        Promise promise = Promise.promise();
        this.closeHandler.close(timeout, (Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Override
    public Future<Void> close() {
        Promise promise = Promise.promise();
        this.closeHandler.close((Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Override
    public void close(Handler<AsyncResult<Void>> completionHandler) {
        this.closeHandler.close(completionHandler);
    }

    @Override
    public void close(long timeout, Handler<AsyncResult<Void>> completionHandler) {
        this.closeHandler.close(completionHandler);
    }

    @Override
    public KafkaWriteStream<K, V> asStream() {
        return this.stream;
    }

    @Override
    public Producer<K, V> unwrap() {
        return this.stream.unwrap();
    }

    private static class SharedProducer
    extends HashMap<Object, KafkaProducer> {
        final Producer producer;
        final CloseHandler closeHandler;

        public SharedProducer(KafkaWriteStream stream) {
            this.producer = stream.unwrap();
            this.closeHandler = new CloseHandler(stream::close);
        }
    }
}

