/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential.source;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import org.wildfly.common.Assert;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.KeyPairCredential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.PublicKeyCredential;
import org.wildfly.security.credential.SecretKeyCredential;
import org.wildfly.security.credential.X509CertificateChainPrivateCredential;
import org.wildfly.security.credential.X509CertificateChainPublicCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.source.ElytronMessages;
import org.wildfly.security.keystore.PasswordEntry;
import org.wildfly.security.x500.X500;

@Deprecated
public final class KeyStoreCredentialSource
implements CredentialSource {
    private final SecurityFactory<KeyStore.Entry> entryFactory;

    public KeyStoreCredentialSource(KeyStore keyStore, String alias, KeyStore.ProtectionParameter protectionParameter) {
        Assert.checkNotNullParam("keyStore", keyStore);
        Assert.checkNotNullParam("alias", alias);
        this.entryFactory = () -> keyStore.getEntry(alias, protectionParameter);
    }

    public KeyStoreCredentialSource(SecurityFactory<KeyStore.Entry> entryFactory) {
        Assert.checkNotNullParam("entryFactory", entryFactory);
        this.entryFactory = entryFactory;
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
        return this.getCredential(credentialType, algorithmName, parameterSpec) != null ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
        try {
            void var5_22;
            KeyStore.Entry entry = this.entryFactory.create();
            if (entry == null) {
                return null;
            }
            if (entry instanceof KeyStore.PrivateKeyEntry) {
                KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)entry;
                X509Certificate[] certificateChain = X500.asX509CertificateArray(privateKeyEntry.getCertificateChain());
                X509Certificate firstCert = certificateChain[0];
                PrivateKey privateKey = privateKeyEntry.getPrivateKey();
                if (credentialType.isAssignableFrom(X509CertificateChainPrivateCredential.class)) {
                    X509CertificateChainPrivateCredential x509CertificateChainPrivateCredential = new X509CertificateChainPrivateCredential(privateKey, certificateChain);
                    return var5_22.castAs(credentialType, algorithmName, parameterSpec);
                } else if (credentialType.isAssignableFrom(X509CertificateChainPublicCredential.class)) {
                    X509CertificateChainPublicCredential x509CertificateChainPublicCredential = new X509CertificateChainPublicCredential(certificateChain);
                    return var5_22.castAs(credentialType, algorithmName, parameterSpec);
                } else if (credentialType.isAssignableFrom(PublicKeyCredential.class)) {
                    PublicKeyCredential publicKeyCredential = new PublicKeyCredential(firstCert.getPublicKey());
                    return var5_22.castAs(credentialType, algorithmName, parameterSpec);
                } else {
                    if (!credentialType.isAssignableFrom(KeyPairCredential.class)) return null;
                    KeyPairCredential keyPairCredential = new KeyPairCredential(new KeyPair(firstCert.getPublicKey(), privateKey));
                }
                return var5_22.castAs(credentialType, algorithmName, parameterSpec);
            } else if (entry instanceof KeyStore.TrustedCertificateEntry) {
                KeyStore.TrustedCertificateEntry trustedCertificateEntry = (KeyStore.TrustedCertificateEntry)entry;
                X509Certificate certificate = (X509Certificate)trustedCertificateEntry.getTrustedCertificate();
                if (!credentialType.isAssignableFrom(PublicKeyCredential.class)) return null;
                PublicKeyCredential publicKeyCredential = new PublicKeyCredential(certificate.getPublicKey());
                return var5_22.castAs(credentialType, algorithmName, parameterSpec);
            } else if (entry instanceof KeyStore.SecretKeyEntry) {
                KeyStore.SecretKeyEntry secretKeyEntry = (KeyStore.SecretKeyEntry)entry;
                if (!credentialType.isAssignableFrom(SecretKeyCredential.class)) return null;
                SecretKeyCredential secretKeyCredential = new SecretKeyCredential(secretKeyEntry.getSecretKey());
                return var5_22.castAs(credentialType, algorithmName, parameterSpec);
            } else {
                if (!(entry instanceof PasswordEntry)) return null;
                PasswordEntry passwordEntry = (PasswordEntry)entry;
                if (!credentialType.isAssignableFrom(PasswordCredential.class)) return null;
                PasswordCredential passwordCredential = new PasswordCredential(passwordEntry.getPassword());
            }
            return var5_22.castAs(credentialType, algorithmName, parameterSpec);
        }
        catch (GeneralSecurityException e) {
            throw ElytronMessages.log.unableToReadCredential(e);
        }
    }
}

