/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.transport;

import com.sun.corba.se.pept.transport.Acceptor;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.transport.ORBSocketFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class DefaultSocketFactoryImpl
implements ORBSocketFactory {
    private ORB orb;
    private static final boolean keepAlive = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            String value = System.getProperty("com.sun.CORBA.transport.enableTcpKeepAlive");
            if (value != null) {
                return new Boolean(!"false".equalsIgnoreCase(value));
            }
            return Boolean.FALSE;
        }
    });

    @Override
    public void setORB(ORB orb) {
        this.orb = orb;
    }

    @Override
    public ServerSocket createServerSocket(String type, InetSocketAddress inetSocketAddress) throws IOException {
        ServerSocketChannel serverSocketChannel = null;
        ServerSocket serverSocket = null;
        if (this.orb.getORBData().acceptorSocketType().equals("SocketChannel")) {
            serverSocketChannel = ServerSocketChannel.open();
            serverSocket = serverSocketChannel.socket();
        } else {
            serverSocket = new ServerSocket();
        }
        serverSocket.bind(inetSocketAddress);
        return serverSocket;
    }

    @Override
    public Socket createSocket(String type, InetSocketAddress inetSocketAddress) throws IOException {
        SocketChannel socketChannel = null;
        Socket socket = null;
        if (this.orb.getORBData().connectionSocketType().equals("SocketChannel")) {
            socketChannel = SocketChannel.open(inetSocketAddress);
            socket = socketChannel.socket();
        } else {
            socket = new Socket(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
        }
        socket.setTcpNoDelay(true);
        if (keepAlive) {
            socket.setKeepAlive(true);
        }
        return socket;
    }

    @Override
    public void setAcceptedSocketOptions(Acceptor acceptor, ServerSocket serverSocket, Socket socket) throws SocketException {
        socket.setTcpNoDelay(true);
        if (keepAlive) {
            socket.setKeepAlive(true);
        }
    }
}

