/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StateTransferConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.ComponentServiceConfigurator;
import org.jboss.as.clustering.infinispan.subsystem.StateTransferResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.service.ServiceConfigurator;

public class StateTransferServiceConfigurator
extends ComponentServiceConfigurator<StateTransferConfiguration> {
    private volatile int chunkSize;
    private volatile long timeout;

    StateTransferServiceConfigurator(PathAddress address) {
        super(CacheComponent.STATE_TRANSFER, address);
    }

    @Override
    public StateTransferConfiguration get() {
        boolean timeoutEnabled = this.timeout > 0L;
        return new ConfigurationBuilder().clustering().stateTransfer().chunkSize(this.chunkSize).fetchInMemoryState(true).awaitInitialTransfer(timeoutEnabled).timeout(timeoutEnabled ? this.timeout : Long.MAX_VALUE).create();
    }

    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.chunkSize = StateTransferResourceDefinition.Attribute.CHUNK_SIZE.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        this.timeout = StateTransferResourceDefinition.Attribute.TIMEOUT.resolveModelAttribute((ExpressionResolver)context, model).asLong();
        return this;
    }
}

