/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Predicate;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ExhaustedAction;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.impl.operations.PingResponse;
import org.infinispan.commons.configuration.ClassWhiteList;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.persistence.Store;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.Util;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.jboss.marshalling.commons.GenericJBossMarshaller;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.remote.configuration.AuthenticationConfiguration;
import org.infinispan.persistence.remote.configuration.ConnectionPoolConfiguration;
import org.infinispan.persistence.remote.configuration.RemoteServerConfiguration;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfiguration;
import org.infinispan.persistence.remote.configuration.SslConfiguration;
import org.infinispan.persistence.remote.logging.Log;
import org.infinispan.persistence.remote.wrapper.HotRodEntryMarshaller;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.FlagAffectedStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.persistence.spi.MarshalledValue;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.persistence.spi.SegmentedAdvancedLoadWriteStore;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;

@Store(shared=true)
@ThreadSafe
@ConfiguredBy(value=RemoteStoreConfiguration.class)
public class RemoteStore<K, V>
implements SegmentedAdvancedLoadWriteStore<K, V>,
FlagAffectedStore<K, V> {
    private static final Log log = (Log)LogFactory.getLog(RemoteStore.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private RemoteStoreConfiguration configuration;
    private volatile RemoteCacheManager remoteCacheManager;
    private volatile RemoteCache<Object, Object> remoteCache;
    private InternalEntryFactory iceFactory;
    private static final String LIFESPAN = "lifespan";
    private static final String MAXIDLE = "maxidle";
    protected InitializationContext ctx;
    private MarshallableEntryFactory<K, V> entryFactory;

    public void init(InitializationContext ctx) {
        this.ctx = ctx;
        this.configuration = (RemoteStoreConfiguration)ctx.getConfiguration();
        this.entryFactory = ctx.getMarshallableEntryFactory();
    }

    public void start() throws PersistenceException {
        Marshaller marshaller;
        if (this.configuration.marshaller() != null) {
            marshaller = (Marshaller)Util.getInstance((String)this.configuration.marshaller(), (ClassLoader)this.ctx.getCache().getAdvancedCache().getClassLoader());
        } else if (this.configuration.hotRodWrapping()) {
            marshaller = new HotRodEntryMarshaller(this.ctx.getByteBufferFactory());
        } else if (this.configuration.rawValues()) {
            ClassWhiteList whiteList = this.ctx.getCache().getCacheManager().getClassWhiteList();
            marshaller = new GenericJBossMarshaller(Thread.currentThread().getContextClassLoader(), whiteList);
        } else {
            marshaller = this.ctx.getPersistenceMarshaller();
        }
        ConfigurationBuilder builder = this.buildRemoteConfiguration(this.configuration, marshaller);
        this.remoteCacheManager = new RemoteCacheManager(builder.build());
        this.remoteCache = this.configuration.remoteCacheName().isEmpty() ? this.remoteCacheManager.getCache() : this.remoteCacheManager.getCache(this.configuration.remoteCacheName());
        if (this.configuration.rawValues() && this.iceFactory == null) {
            this.iceFactory = (InternalEntryFactory)this.ctx.getCache().getAdvancedCache().getComponentRegistry().getComponent(InternalEntryFactory.class);
        }
    }

    public void stop() throws PersistenceException {
        this.remoteCacheManager.stop();
    }

    public boolean isAvailable() {
        try {
            PingResponse pr = ((RemoteCacheImpl)this.remoteCache).ping();
            return pr.isSuccess();
        }
        catch (Exception e) {
            return false;
        }
    }

    public MarshallableEntry<K, V> get(int segment, Object key) {
        return this.loadEntry(key);
    }

    public MarshallableEntry<K, V> loadEntry(Object key) throws PersistenceException {
        if (this.configuration.rawValues()) {
            Object unwrappedKey = key instanceof WrappedByteArray ? (Object)((WrappedByteArray)key).getBytes() : key;
            MetadataValue value = this.remoteCache.getWithMetadata(unwrappedKey);
            if (value != null) {
                Metadata metadata = new EmbeddedMetadata.Builder().version((EntryVersion)new NumericVersion(value.getVersion())).lifespan((long)value.getLifespan(), TimeUnit.SECONDS).maxIdle((long)value.getMaxIdle(), TimeUnit.SECONDS).build();
                long created = value.getCreated();
                long lastUsed = value.getLastUsed();
                Object realValue = value.getValue();
                if (realValue instanceof byte[]) {
                    realValue = new WrappedByteArray((byte[])realValue);
                }
                return this.entryFactory.create(key, realValue, metadata, null, created, lastUsed);
            }
            return null;
        }
        Object unwrappedKey = key instanceof WrappedByteArray ? (Object)((WrappedByteArray)key).getBytes() : key;
        Object value = this.remoteCache.get(unwrappedKey);
        if (value == null) {
            return null;
        }
        if (value instanceof MarshalledValue) {
            return this.entryFactory.create(key, (MarshalledValue)value);
        }
        return this.entryFactory.create(key, value);
    }

    public boolean contains(int segment, Object key) {
        return this.contains(key);
    }

    public boolean contains(Object key) throws PersistenceException {
        if (key instanceof WrappedByteArray) {
            key = ((WrappedByteArray)key).getBytes();
        }
        return this.remoteCache.containsKey(key);
    }

    public Flowable<K> publishKeys(java.util.function.Predicate<? super K> filter) {
        return this.publishKeys(null, filter);
    }

    public Flowable<K> publishKeys(IntSet segments, java.util.function.Predicate<? super K> filter) {
        Flowable keyFlowable = RemoteStore.entryFlowable(this.remoteCache.keySet(segments).iterator()).map(RemoteStore::wrap);
        if (filter != null) {
            keyFlowable = keyFlowable.filter(filter::test);
        }
        return keyFlowable;
    }

    public Publisher<MarshallableEntry<K, V>> entryPublisher(java.util.function.Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata) {
        return this.entryPublisher(null, filter, fetchValue, fetchMetadata);
    }

    public Publisher<MarshallableEntry<K, V>> entryPublisher(IntSet segments, java.util.function.Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata) {
        if (!fetchValue && !fetchMetadata) {
            Flowable<? super K> keyFlowable = this.publishKeys(segments, filter);
            return keyFlowable.map(key -> this.entryFactory.create(key));
        }
        if (this.configuration.rawValues()) {
            Predicate filterToUse;
            Predicate predicate = filterToUse = filter == null ? null : e -> filter.test((Object)RemoteStore.wrap(e.getKey()));
            if (!fetchMetadata) {
                Flowable entryFlowable = RemoteStore.entryFlowable(this.remoteCache.entrySet(segments).iterator());
                if (filterToUse != null) {
                    entryFlowable = entryFlowable.filter(filterToUse);
                }
                return entryFlowable.map(e -> this.entryFactory.create(RemoteStore.wrap(e.getKey()), RemoteStore.wrap(e.getValue())));
            }
            Flowable entryMetatdataFlowable = RemoteStore.entryFlowable(this.remoteCache.retrieveEntriesWithMetadata((Set)segments, 512));
            if (filterToUse != null) {
                entryMetatdataFlowable = entryMetatdataFlowable.filter(filterToUse);
            }
            return entryMetatdataFlowable.map(e -> {
                MetadataValue value = (MetadataValue)e.getValue();
                Metadata metadata = new EmbeddedMetadata.Builder().version((EntryVersion)new NumericVersion(value.getVersion())).lifespan((long)value.getLifespan(), TimeUnit.SECONDS).maxIdle((long)value.getMaxIdle(), TimeUnit.SECONDS).build();
                long created = value.getCreated();
                long lastUsed = value.getLastUsed();
                Object realValue = value.getValue();
                return this.entryFactory.create(RemoteStore.wrap(e.getKey()), RemoteStore.wrap(realValue), metadata, null, created, lastUsed);
            });
        }
        Flowable entryFlowable = RemoteStore.entryFlowable(this.remoteCache.entrySet(segments).iterator());
        if (filter != null) {
            entryFlowable = entryFlowable.filter(e -> filter.test((Object)RemoteStore.wrap(e.getKey())));
        }
        return entryFlowable.map(e -> e.getValue() == null ? null : this.entryFactory.create(e.getKey(), (MarshalledValue)e.getValue()));
    }

    private static <E> Flowable<E> entryFlowable(CloseableIterator<E> closeableIteratorSet) {
        return Flowable.using(() -> closeableIteratorSet, iter -> Flowable.fromIterable(() -> iter), AutoCloseable::close);
    }

    private static <T> T wrap(Object obj) {
        if (obj instanceof byte[]) {
            obj = new WrappedByteArray((byte[])obj);
        }
        return (T)obj;
    }

    public int size() {
        return this.remoteCache.size();
    }

    public int size(IntSet segments) {
        return PersistenceUtil.count((SegmentedAdvancedLoadWriteStore)this, (IntSet)segments);
    }

    public void purge(Executor threadPool, AdvancedCacheWriter.PurgeListener task) {
    }

    public void write(int segment, MarshallableEntry<? extends K, ? extends V> entry) {
        this.write(entry);
    }

    public void write(MarshallableEntry entry) throws PersistenceException {
        Metadata metadata;
        if (trace) {
            log.tracef("Adding entry: %s", entry);
        }
        long lifespan = (metadata = entry.getMetadata()) != null ? metadata.lifespan() : -1L;
        long maxIdle = metadata != null ? metadata.maxIdle() : -1L;
        Object key = this.getKey(entry);
        Object value = this.getValue(entry);
        this.remoteCache.put(key, value, this.toSeconds(lifespan, entry.getKey(), LIFESPAN), TimeUnit.SECONDS, this.toSeconds(maxIdle, entry.getKey(), MAXIDLE), TimeUnit.SECONDS);
    }

    private Object getKey(MarshallableEntry entry) {
        Object key = entry.getKey();
        if (key instanceof WrappedByteArray) {
            return ((WrappedByteArray)key).getBytes();
        }
        return key;
    }

    private Object getValue(MarshallableEntry entry) {
        if (this.configuration.rawValues()) {
            Object value = entry.getValue();
            return value instanceof WrappedByteArray ? (Object)((WrappedByteArray)value).getBytes() : value;
        }
        return entry.getMarshalledValue();
    }

    public CompletionStage<Void> bulkUpdate(Publisher<MarshallableEntry<? extends K, ? extends V>> publisher) {
        return Flowable.fromPublisher(publisher).buffer(this.configuration.maxBatchSize()).doOnNext(entries -> this.remoteCache.putAll(entries.stream().collect(Collectors.toMap(this::getKey, this::getValue)))).doOnError(PersistenceException::new).ignoreElements().toCompletionStage(null);
    }

    public void clear() throws PersistenceException {
        this.remoteCache.clear();
    }

    public void clear(IntSet segments) {
        CompletionStage stage = this.publishKeys(segments, null).doOnNext(k -> this.remoteCache.remove(k)).ignoreElements().toCompletionStage(null);
        CompletionStages.join((CompletionStage)stage);
    }

    public boolean delete(int segment, Object key) {
        return this.delete(key);
    }

    public boolean delete(Object key) throws PersistenceException {
        if (key instanceof WrappedByteArray) {
            key = ((WrappedByteArray)key).getBytes();
        }
        return this.remoteCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).remove(key) != null;
    }

    private long toSeconds(long millis, Object key, String desc) {
        if (millis > 0L && millis < 1000L) {
            if (trace) {
                log.tracef("Adjusting %s time for key %s from %d millis to 1 sec, as milliseconds are not supported by HotRod", desc, key, millis);
            }
            return 1L;
        }
        return TimeUnit.MILLISECONDS.toSeconds(millis);
    }

    public void setInternalCacheEntryFactory(InternalEntryFactory iceFactory) {
        if (this.iceFactory != null) {
            throw new IllegalStateException();
        }
        this.iceFactory = iceFactory;
    }

    public RemoteCache<Object, Object> getRemoteCache() {
        return this.remoteCache;
    }

    private ConfigurationBuilder buildRemoteConfiguration(RemoteStoreConfiguration configuration, Marshaller marshaller) {
        AuthenticationConfiguration auth;
        ConfigurationBuilder builder = new ConfigurationBuilder();
        for (RemoteServerConfiguration s : configuration.servers()) {
            builder.addServer().host(s.host()).port(s.port());
        }
        ConnectionPoolConfiguration poolConfiguration = configuration.connectionPool();
        Long connectionTimeout = configuration.connectionTimeout();
        Long socketTimeout = configuration.socketTimeout();
        builder.classLoader(((Object)((Object)configuration)).getClass().getClassLoader()).balancingStrategy(configuration.balancingStrategy()).connectionPool().exhaustedAction(ExhaustedAction.valueOf((String)poolConfiguration.exhaustedAction().toString())).maxActive(poolConfiguration.maxActive()).minIdle(poolConfiguration.minIdle()).minEvictableIdleTime(poolConfiguration.minEvictableIdleTime()).connectionTimeout(connectionTimeout.intValue()).forceReturnValues(configuration.forceReturnValues()).keySizeEstimate(configuration.keySizeEstimate()).marshaller(marshaller).asyncExecutorFactory().factoryClass(configuration.asyncExecutorFactory().factory().getClass()).socketTimeout(socketTimeout.intValue()).tcpNoDelay(configuration.tcpNoDelay()).valueSizeEstimate(configuration.valueSizeEstimate()).version(configuration.protocol() == null ? ProtocolVersion.DEFAULT_PROTOCOL_VERSION : configuration.protocol());
        SslConfiguration ssl = configuration.security().ssl();
        if (ssl.enabled()) {
            builder.security().ssl().enable().keyStoreType(ssl.keyStoreType()).keyAlias(ssl.keyAlias()).keyStoreFileName(ssl.keyStoreFileName()).keyStorePassword(ssl.keyStorePassword()).keyStoreCertificatePassword(ssl.keyStoreCertificatePassword()).trustStoreFileName(ssl.trustStoreFileName()).trustStorePassword(ssl.trustStorePassword()).trustStoreType(ssl.trustStoreType()).protocol(ssl.protocol()).sniHostName(ssl.sniHostName());
        }
        if ((auth = configuration.security().authentication()).enabled()) {
            builder.security().authentication().enable().callbackHandler(auth.callbackHandler()).clientSubject(auth.clientSubject()).saslMechanism(auth.saslMechanism()).serverName(auth.serverName()).saslProperties(auth.saslProperties()).username(auth.username()).password(auth.password()).realm(auth.realm());
        }
        builder.withProperties(configuration.properties());
        return builder;
    }

    public RemoteStoreConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean shouldWrite(long commandFlags) {
        return !EnumUtil.containsAny((long)FlagBitSets.ROLLING_UPGRADE, (long)commandFlags);
    }
}

