/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session;

import java.time.Duration;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Manager;
import org.wildfly.clustering.ee.ManagerFactory;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionAttributes;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionMetaData;
import org.wildfly.common.function.Functions;

public class ConcurrentSessionManager<L, B extends Batch>
implements SessionManager<L, B> {
    private final SessionManager<L, B> manager;
    private final Manager<String, Session<L>> concurrentManager;

    public ConcurrentSessionManager(SessionManager<L, B> manager, ManagerFactory<String, Session<L>> concurrentManagerFactory) {
        this.manager = manager;
        this.concurrentManager = concurrentManagerFactory.apply(Functions.discardingConsumer(), new Consumer<Session<L>>(){

            @Override
            public void accept(Session<L> session) {
                ((ConcurrentSession)session).closeSession();
            }
        });
    }

    public Session<L> findSession(final String id) {
        final SessionManager<L, B> manager = this.manager;
        Function factory = new Function<Runnable, Session<L>>(){

            @Override
            public ConcurrentSession<L> apply(Runnable closeTask) {
                Session session = manager.findSession(id);
                return session != null ? new ConcurrentSession(session, closeTask) : null;
            }
        };
        return (Session)this.concurrentManager.apply((Object)id, factory);
    }

    public Session<L> createSession(final String id) {
        final SessionManager<L, B> manager = this.manager;
        Function factory = new Function<Runnable, Session<L>>(){

            @Override
            public ConcurrentSession<L> apply(Runnable closeTask) {
                Session session = manager.createSession(id);
                return new ConcurrentSession(session, closeTask);
            }
        };
        return (Session)this.concurrentManager.apply((Object)id, factory);
    }

    public String createIdentifier() {
        return (String)this.manager.createIdentifier();
    }

    public void start() {
        this.manager.start();
    }

    public void stop() {
        this.manager.stop();
    }

    public long getActiveSessionCount() {
        return this.manager.getActiveSessionCount();
    }

    public Duration getDefaultMaxInactiveInterval() {
        return this.manager.getDefaultMaxInactiveInterval();
    }

    public void setDefaultMaxInactiveInterval(Duration duration) {
        this.manager.setDefaultMaxInactiveInterval(duration);
    }

    public Batcher<B> getBatcher() {
        return this.manager.getBatcher();
    }

    public Set<String> getActiveSessions() {
        return this.manager.getActiveSessions();
    }

    public Set<String> getLocalSessions() {
        return this.manager.getLocalSessions();
    }

    public ImmutableSession readSession(String id) {
        return this.manager.readSession(id);
    }

    public Duration getStopTimeout() {
        return this.manager.getStopTimeout();
    }

    private static class ConcurrentSession<L>
    implements Session<L> {
        private final Session<L> session;
        private final Runnable closeTask;

        ConcurrentSession(Session<L> session, Runnable closeTask) {
            this.session = session;
            this.closeTask = closeTask;
        }

        void closeSession() {
            this.session.close();
        }

        public String getId() {
            return this.session.getId();
        }

        public boolean isValid() {
            return this.session.isValid();
        }

        public SessionMetaData getMetaData() {
            return this.session.getMetaData();
        }

        public SessionAttributes getAttributes() {
            return this.session.getAttributes();
        }

        public void invalidate() {
            this.session.invalidate();
            this.closeTask.run();
        }

        public void close() {
            this.closeTask.run();
        }

        public L getLocalContext() {
            return (L)this.session.getLocalContext();
        }
    }
}

