/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.dispatcher;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.server.dispatcher.AutoCloseableCommandDispatcherFactory;
import org.wildfly.clustering.server.dispatcher.ManagedCommandDispatcher;
import org.wildfly.clustering.server.logging.ClusteringServerLogger;

public class ManagedCommandDispatcherFactory
implements AutoCloseableCommandDispatcherFactory {
    private final AutoCloseableCommandDispatcherFactory factory;
    private final Map<Object, Map.Entry<CommandDispatcher<?>, Integer>> dispatchers = new HashMap();

    public ManagedCommandDispatcherFactory(AutoCloseableCommandDispatcherFactory factory) {
        this.factory = factory;
    }

    @Override
    public void close() {
        this.factory.close();
    }

    public Group getGroup() {
        return this.factory.getGroup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <C> CommandDispatcher<C> createCommandDispatcher(Object id, C context, ClassLoader loader) {
        Map<Object, Map.Entry<CommandDispatcher<?>, Integer>> map = this.dispatchers;
        synchronized (map) {
            Map.Entry<CommandDispatcher<?>, Integer> existingEntry = this.dispatchers.get(id);
            if (existingEntry == null) {
                CommandDispatcher dispatcher = this.factory.createCommandDispatcher(id, context, loader);
                ManagedCommandDispatcher result = new ManagedCommandDispatcher(dispatcher, () -> {
                    Map<Object, Map.Entry<CommandDispatcher<?>, Integer>> map = this.dispatchers;
                    synchronized (map) {
                        Map.Entry<CommandDispatcher<?>, Integer> entry;
                        Map.Entry<CommandDispatcher<?>, Integer> entry2 = entry = this.dispatchers.get(id);
                        synchronized (entry2) {
                            int refs = entry.getValue() - 1;
                            if (refs == 0) {
                                dispatcher.close();
                                this.dispatchers.remove(id);
                            } else {
                                entry.setValue(refs);
                            }
                        }
                    }
                });
                this.dispatchers.put(id, new AbstractMap.SimpleEntry(result, 1));
                return result;
            }
            CommandDispatcher<?> result = existingEntry.getKey();
            if (result.getContext() != context) {
                throw ClusteringServerLogger.ROOT_LOGGER.commandDispatcherContextMismatch(id);
            }
            Map.Entry<CommandDispatcher<?>, Integer> entry = existingEntry;
            synchronized (entry) {
                int refs = existingEntry.getValue() + 1;
                existingEntry.setValue(refs);
            }
            return result;
        }
    }
}

