/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.provider;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.concurrent.CompletableFutures;
import org.jboss.as.clustering.context.DefaultExecutorService;
import org.jboss.as.clustering.context.ExecutorServiceFactory;
import org.wildfly.clustering.Registration;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandDispatcherException;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Invoker;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.infinispan.InfinispanCacheProperties;
import org.wildfly.clustering.ee.infinispan.retry.RetryingInvoker;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.GroupListener;
import org.wildfly.clustering.group.Membership;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.provider.ServiceProviderRegistration;
import org.wildfly.clustering.provider.ServiceProviderRegistry;
import org.wildfly.clustering.server.logging.ClusteringServerLogger;
import org.wildfly.clustering.server.provider.CacheServiceProviderRegistryConfiguration;
import org.wildfly.clustering.server.provider.ConcurrentAddressSetAddFunction;
import org.wildfly.clustering.server.provider.ConcurrentAddressSetRemoveFunction;
import org.wildfly.clustering.server.provider.CopyOnWriteAddressSetAddFunction;
import org.wildfly.clustering.server.provider.CopyOnWriteAddressSetRemoveFunction;
import org.wildfly.clustering.server.provider.GetLocalServicesCommand;
import org.wildfly.clustering.server.provider.SimpleServiceProviderRegistration;
import org.wildfly.common.function.ExceptionRunnable;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.manager.WildFlySecurityManager;

@Listener
public class CacheServiceProviderRegistry<T>
implements ServiceProviderRegistry<T>,
GroupListener,
AutoCloseable {
    final Batcher<? extends Batch> batcher;
    private final ConcurrentMap<T, Map.Entry<ServiceProviderRegistration.Listener, ExecutorService>> listeners = new ConcurrentHashMap<T, Map.Entry<ServiceProviderRegistration.Listener, ExecutorService>>();
    private final Cache<T, Set<Address>> cache;
    private final org.wildfly.clustering.spi.group.Group<Address> group;
    private final Registration groupRegistration;
    private final CommandDispatcher<Set<T>> dispatcher;
    private final Invoker invoker;
    private final CacheProperties properties;

    public CacheServiceProviderRegistry(CacheServiceProviderRegistryConfiguration<T> config) {
        this.group = config.getGroup();
        this.cache = config.getCache();
        this.batcher = config.getBatcher();
        this.dispatcher = config.getCommandDispatcherFactory().createCommandDispatcher(config.getId(), this.listeners.keySet(), WildFlySecurityManager.getClassLoaderPrivileged(this.getClass()));
        this.cache.addListener((Object)this);
        this.groupRegistration = this.group.register((Object)this);
        this.invoker = new RetryingInvoker(this.cache);
        this.properties = new InfinispanCacheProperties(this.cache.getCacheConfiguration());
    }

    @Override
    public void close() {
        this.groupRegistration.close();
        this.cache.removeListener((Object)this);
        this.dispatcher.close();
        for (Map.Entry entry : this.listeners.values()) {
            ExecutorService executor = (ExecutorService)entry.getValue();
            if (executor == null) continue;
            this.shutdown(executor);
        }
        this.listeners.clear();
    }

    private void shutdown(ExecutorService executor) {
        WildFlySecurityManager.doUnchecked((Object)executor, (ParametricPrivilegedAction)DefaultExecutorService.SHUTDOWN_NOW_ACTION);
        try {
            executor.awaitTermination(this.cache.getCacheConfiguration().transaction().cacheStopTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public Group getGroup() {
        return this.group;
    }

    public ServiceProviderRegistration<T> register(T service) {
        return this.register(service, null);
    }

    public ServiceProviderRegistration<T> register(final T service, ServiceProviderRegistration.Listener listener) {
        AbstractMap.SimpleEntry<ServiceProviderRegistration.Listener, Object> newEntry = new AbstractMap.SimpleEntry<ServiceProviderRegistration.Listener, Object>(listener, null);
        Map.Entry entry = this.listeners.computeIfAbsent(service, key -> {
            if (listener != null) {
                newEntry.setValue(new DefaultExecutorService(listener.getClass(), (Function)ExecutorServiceFactory.SINGLE_THREAD));
            }
            return newEntry;
        });
        if (entry != newEntry) {
            throw new IllegalArgumentException(service.toString());
        }
        ExceptionRunnable<CacheException> registerAction = new ExceptionRunnable<CacheException>(){

            public void run() throws CacheException {
                CacheServiceProviderRegistry.this.registerLocal(service);
            }
        };
        this.invoker.invoke((ExceptionRunnable)registerAction);
        return new SimpleServiceProviderRegistration<T>(service, this, () -> {
            Address localAddress = (Address)this.group.getAddress(this.group.getLocalMember());
            try (Batch batch = this.batcher.createBatch();){
                this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS, Flag.IGNORE_RETURN_VALUES}).compute(service, (BiFunction)(this.properties.isTransactional() ? new CopyOnWriteAddressSetRemoveFunction(localAddress) : new ConcurrentAddressSetRemoveFunction(localAddress)));
            }
            finally {
                ExecutorService executor;
                Map.Entry oldEntry = (Map.Entry)this.listeners.remove(service);
                if (oldEntry != null && (executor = (ExecutorService)oldEntry.getValue()) != null) {
                    this.shutdown(executor);
                }
            }
        });
    }

    void registerLocal(T service) {
        try (Batch batch = this.batcher.createBatch();){
            this.register((Address)this.group.getAddress(this.group.getLocalMember()), service);
        }
    }

    void register(Address address, T service) {
        this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS, Flag.IGNORE_RETURN_VALUES}).compute(service, (BiFunction)(this.properties.isTransactional() ? new CopyOnWriteAddressSetAddFunction(address) : new ConcurrentAddressSetAddFunction(address)));
    }

    public Set<Node> getProviders(T service) {
        Set addresses = (Set)this.cache.get(service);
        if (addresses == null) {
            return Collections.emptySet();
        }
        TreeSet<Node> members = new TreeSet<Node>();
        for (Address address : addresses) {
            members.add(this.group.createNode((Object)address));
        }
        return Collections.unmodifiableSet(members);
    }

    public Set<T> getServices() {
        return this.cache.keySet();
    }

    public void membershipChanged(Membership previousMembership, Membership membership, boolean merged) {
        if (membership.isCoordinator()) {
            HashSet previousMembers = new HashSet(previousMembership.getMembers());
            HashSet members = new HashSet(membership.getMembers());
            ArrayList<Object> leftMembers = new ArrayList<Object>(previousMembers.size());
            for (Object previousMember : previousMembers) {
                if (members.contains(previousMember)) continue;
                leftMembers.add(this.group.getAddress((Node)previousMember));
            }
            ArrayList<Object> joinedMembers = new ArrayList<Object>(members.size());
            for (Node member : members) {
                if (previousMembers.contains(member)) continue;
                joinedMembers.add(this.group.getAddress(member));
            }
            if (!leftMembers.isEmpty()) {
                Batch batch = this.batcher.createBatch();
                Object object = null;
                try (CloseableIterator closeableIterator = this.cache.entrySet().iterator();){
                    while (closeableIterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)closeableIterator.next();
                        Set addresses = (Set)entry.getValue();
                        if (!addresses.removeAll(leftMembers)) continue;
                        entry.setValue(addresses);
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (batch != null) {
                        if (object != null) {
                            try {
                                batch.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            batch.close();
                        }
                    }
                }
            }
            if (merged) {
                GetLocalServicesCommand command = new GetLocalServicesCommand();
                for (final Address address : joinedMembers) {
                    BiConsumer completionHandler = new BiConsumer<Collection<T>, Throwable>(){

                        @Override
                        public void accept(Collection<T> services, Throwable exception) {
                            if (services != null) {
                                try (Batch batch = CacheServiceProviderRegistry.this.batcher.createBatch();){
                                    for (Object service : services) {
                                        CacheServiceProviderRegistry.this.register(address, service);
                                    }
                                }
                            } else if (exception != null) {
                                ClusteringServerLogger.ROOT_LOGGER.warn(exception.getLocalizedMessage(), exception);
                            }
                        }
                    };
                    try {
                        this.dispatcher.executeOnMember(command, this.group.createNode((Object)address)).whenComplete(completionHandler);
                    }
                    catch (CommandDispatcherException e) {
                        ClusteringServerLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
                    }
                }
            }
        }
    }

    @CacheEntryCreated
    @CacheEntryModified
    public CompletionStage<Void> modified(CacheEntryEvent<T, Set<Address>> event) {
        ServiceProviderRegistration.Listener listener;
        Map.Entry entry;
        if (!event.isPre() && (entry = (Map.Entry)this.listeners.get(event.getKey())) != null && (listener = (ServiceProviderRegistration.Listener)entry.getKey()) != null) {
            ExecutorService executor = (ExecutorService)entry.getValue();
            try {
                executor.submit(() -> {
                    TreeSet<Node> members = new TreeSet<Node>();
                    for (Address address : (Set)event.getValue()) {
                        members.add(this.group.createNode((Object)address));
                    }
                    try {
                        listener.providersChanged(members);
                    }
                    catch (Throwable e) {
                        ClusteringServerLogger.ROOT_LOGGER.serviceProviderRegistrationListenerFailed(e, this.cache.getCacheManager().getCacheManagerConfiguration().cacheManagerName(), this.cache.getName(), members);
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
        return CompletableFutures.completedNull();
    }
}

