/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.MinMaxValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ObjectListAttributeDefinition
extends ListAttributeDefinition {
    private final ObjectTypeAttributeDefinition valueType;

    private ObjectListAttributeDefinition(Builder builder) {
        super(builder);
        this.valueType = builder.valueType;
    }

    @Override
    public ModelNode addResourceAttributeDescription(ResourceBundle bundle, String prefix, ModelNode resourceDescription) {
        ModelNode attr = this.getNoTextDescription(false);
        attr.get("description").set(this.getAttributeTextDescription(bundle, prefix));
        ModelNode result = resourceDescription.get(new String[]{"attributes", this.getName()}).set(attr);
        this.addValueTypeDescription(result, prefix, bundle, false, null, null);
        this.addAccessConstraints(result, bundle.getLocale());
        return result;
    }

    @Override
    public ModelNode addOperationParameterDescription(ResourceBundle bundle, String prefix, ModelNode operationDescription) {
        ModelNode param = this.getNoTextDescription(true);
        param.get("description").set(this.getAttributeTextDescription(bundle, prefix));
        ModelNode result = operationDescription.get(new String[]{"request-properties", this.getName()}).set(param);
        this.addValueTypeDescription(result, prefix, bundle, true, null, null);
        return result;
    }

    @Override
    public void addCapabilityRequirements(OperationContext context, Resource resource, ModelNode attributeValue) {
        if (attributeValue.isDefined()) {
            for (ModelNode element : attributeValue.asList()) {
                this.valueType.addCapabilityRequirements(context, resource, element);
            }
        }
    }

    @Override
    public void removeCapabilityRequirements(OperationContext context, Resource resource, ModelNode attributeValue) {
        if (attributeValue.isDefined()) {
            for (ModelNode element : attributeValue.asList()) {
                this.valueType.removeCapabilityRequirements(context, resource, element);
            }
        }
    }

    @Override
    protected void addValueTypeDescription(ModelNode node, ResourceBundle bundle) {
        this.addValueTypeDescription(node, this.valueType.getName(), bundle, false, null, null);
    }

    @Override
    protected void addAttributeValueTypeDescription(ModelNode node, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        this.addValueTypeDescription(node, this.getName(), bundle, false, resolver, locale);
    }

    @Override
    protected void addOperationParameterValueTypeDescription(ModelNode node, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        this.addValueTypeDescription(node, this.getName(), bundle, true, resolver, locale);
    }

    @Override
    public void marshallAsElement(ModelNode resourceModel, boolean marshalDefault, XMLStreamWriter writer) throws XMLStreamException {
        if (resourceModel.hasDefined(this.getName())) {
            writer.writeStartElement(this.getXmlName());
            for (ModelNode handler : resourceModel.get(this.getName()).asList()) {
                this.valueType.getMarshaller().marshallAsElement(this, handler, true, writer);
            }
            writer.writeEndElement();
        }
    }

    @Override
    public ModelNode resolveValue(ExpressionResolver resolver, ModelNode value) throws OperationFailedException {
        ModelNode superResult;
        ModelNode modelNode = superResult = value.getType() == ModelType.LIST ? value : super.resolveValue(resolver, value);
        if (superResult.getType() != ModelType.LIST) {
            return superResult;
        }
        ModelNode clone = superResult == value ? value.clone() : superResult;
        ModelNode result = new ModelNode();
        result.setEmptyList();
        for (ModelNode element : clone.asList()) {
            result.add(this.valueType.resolveValue(resolver, element));
        }
        this.getValidator().validateParameter(this.getName(), result);
        return result;
    }

    @Override
    protected ModelNode convertParameterElementExpressions(ModelNode parameterElement) {
        return this.valueType.convertParameterExpressions(parameterElement);
    }

    protected void addValueTypeDescription(ModelNode node, String prefix, ResourceBundle bundle, boolean forOperation, ResourceDescriptionResolver resolver, Locale locale) {
        ParameterValidator validator;
        String[] requires;
        String[] alternatives;
        MeasurementUnit measurementUnit;
        node.get("description");
        node.get("expressions-allowed").set(this.valueType.isAllowExpression());
        node.get("required").set(this.valueType.isRequired());
        node.get("nillable").set(this.valueType.isNillable());
        ModelNode defaultValue = this.valueType.getDefaultValue();
        if (!forOperation && defaultValue != null && defaultValue.isDefined()) {
            node.get("default").set(defaultValue);
        }
        if ((measurementUnit = this.valueType.getMeasurementUnit()) != null && measurementUnit != MeasurementUnit.NONE) {
            node.get("unit").set(measurementUnit.getName());
        }
        if ((alternatives = this.valueType.getAlternatives()) != null) {
            for (String alternative : alternatives) {
                node.get("alternatives").add(alternative);
            }
        }
        if ((requires = this.valueType.getRequires()) != null) {
            for (String required : requires) {
                node.get("requires").add(required);
            }
        }
        if ((validator = this.valueType.getValidator()) instanceof MinMaxValidator) {
            Long max;
            MinMaxValidator minMax = (MinMaxValidator)((Object)validator);
            Long min = minMax.getMin();
            if (min != null) {
                switch (this.valueType.getType()) {
                    case STRING: 
                    case LIST: 
                    case OBJECT: 
                    case BYTES: {
                        node.get("min-length").set(min.longValue());
                        break;
                    }
                    default: {
                        node.get("min").set(min.longValue());
                    }
                }
            }
            if ((max = minMax.getMax()) != null) {
                switch (this.valueType.getType()) {
                    case STRING: 
                    case LIST: 
                    case OBJECT: 
                    case BYTES: {
                        node.get("max-length").set(max.longValue());
                        break;
                    }
                    default: {
                        node.get("max").set(max.longValue());
                    }
                }
            }
        }
        this.addAllowedValuesToDescription(node, validator);
        this.valueType.addValueTypeDescription(node, prefix, bundle, forOperation, resolver, locale);
    }

    @Override
    protected void addAllowedValuesToDescription(ModelNode result, ParameterValidator validator) {
    }

    public final ObjectTypeAttributeDefinition getValueType() {
        return this.valueType;
    }

    private static class ListParameterCorrector
    implements ParameterCorrector {
        private final ParameterCorrector listCorrector;
        private final ParameterCorrector elementCorrector;

        private ListParameterCorrector(ParameterCorrector listCorrector, ParameterCorrector elementCorrector) {
            this.listCorrector = listCorrector;
            this.elementCorrector = elementCorrector;
        }

        @Override
        public ModelNode correct(ModelNode newValue, ModelNode currentValue) {
            ModelNode result = newValue;
            if (newValue.isDefined()) {
                int curSize = currentValue.isDefined() ? currentValue.asInt() : 0;
                for (int i = 0; i < newValue.asInt(); ++i) {
                    ModelNode toCorrect = newValue.get(i);
                    ModelNode corrected = this.elementCorrector.correct(toCorrect, i < curSize ? currentValue.get(i) : new ModelNode());
                    if (corrected.equals(toCorrect)) continue;
                    toCorrect.set(corrected);
                }
            }
            if (this.listCorrector != null) {
                result = this.listCorrector.correct(result, currentValue);
            }
            return result;
        }
    }

    public static final class Builder
    extends ListAttributeDefinition.Builder<Builder, ObjectListAttributeDefinition> {
        private ObjectTypeAttributeDefinition valueType;

        public Builder(String name, ObjectTypeAttributeDefinition valueType) {
            super(name);
            this.valueType = valueType;
            this.setElementValidator(valueType.getValidator());
            this.setAttributeParser(AttributeParser.OBJECT_LIST_PARSER);
            this.setAttributeMarshaller(AttributeMarshaller.OBJECT_LIST_MARSHALLER);
        }

        public Builder(ObjectListAttributeDefinition basis) {
            super(basis);
            this.valueType = basis.valueType;
        }

        public Builder setValueType(ObjectTypeAttributeDefinition valueType) {
            this.valueType = valueType;
            return this;
        }

        public static Builder of(String name, ObjectTypeAttributeDefinition valueType) {
            return new Builder(name, valueType);
        }

        @Override
        public ObjectListAttributeDefinition build() {
            List<AccessConstraintDefinition> valueConstraints = this.valueType.getAccessConstraints();
            if (!valueConstraints.isEmpty()) {
                LinkedHashSet<AccessConstraintDefinition> acdSet = new LinkedHashSet<AccessConstraintDefinition>();
                AccessConstraintDefinition[] curAcds = this.getAccessConstraints();
                if (curAcds != null && curAcds.length > 0) {
                    Collections.addAll(acdSet, curAcds);
                }
                acdSet.addAll(valueConstraints);
                this.setAccessConstraints(acdSet.toArray(new AccessConstraintDefinition[acdSet.size()]));
            }
            if (this.valueType.getCorrector() != null) {
                this.setCorrector(new ListParameterCorrector(this.getCorrector(), this.valueType.getCorrector()));
            }
            return new ObjectListAttributeDefinition(this);
        }

        @Override
        public Builder setAllowNull(boolean allowNull) {
            return (Builder)super.setAllowNull(allowNull);
        }
    }
}

