/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.function.Consumer;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.wildfly.common.function.ExceptionFunction;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronDoohickey;
import org.wildfly.extension.elytron.TrivialService;

abstract class DoohickeyAddHandler<T>
extends BaseAddHandler {
    private final RuntimeCapability<?> runtimeCapability;
    private final String apiCapabilityName;

    public DoohickeyAddHandler(RuntimeCapability<?> runtimeCapability, AttributeDefinition[] configAttributes, String apiCapabilityName) {
        super(runtimeCapability, configAttributes);
        this.runtimeCapability = runtimeCapability;
        this.apiCapabilityName = apiCapabilityName;
    }

    @Override
    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.recordCapabilitiesAndRequirements(context, operation, resource);
        if (this.requiresRuntime(context)) {
            ElytronDoohickey<T> elytronDoohickey = this.createDoohickey(context.getCurrentAddress());
            context.registerCapability(RuntimeCapability.Builder.of((String)this.apiCapabilityName, (boolean)true, elytronDoohickey).build().fromBaseCapability(context.getCurrentAddressValue()));
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        String name = context.getCurrentAddressValue();
        ExceptionFunction runtimeApi = (ExceptionFunction)context.getCapabilityRuntimeAPI(this.apiCapabilityName, name, ExceptionFunction.class);
        ElytronDoohickey doohickey = (ElytronDoohickey)runtimeApi;
        doohickey.resolveRuntime(context);
        CapabilityServiceBuilder serviceBuilder = context.getCapabilityServiceTarget().addCapability(this.runtimeCapability);
        Consumer valueConsumer = serviceBuilder.provides(new RuntimeCapability[]{this.runtimeCapability});
        doohickey.prepareService(context, serviceBuilder);
        TrivialService<Object> trivialService = new TrivialService<Object>(doohickey::get, valueConsumer);
        ElytronDefinition.commonDependencies(serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).setInstance(trivialService), true, this.dependOnProviderRegistration()).install();
    }

    protected boolean dependOnProviderRegistration() {
        return true;
    }

    protected ServiceController.Mode getInitialMode() {
        return ServiceController.Mode.ACTIVE;
    }

    protected abstract ElytronDoohickey<T> createDoohickey(PathAddress var1);
}

