/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.HashMap;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.common.function.ExceptionBiConsumer;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronReloadRequiredWriteAttributeHandler;
import org.wildfly.extension.elytron.ElytronRuntimeOnlyHandler;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.expression.ElytronExpressionResolver;

class ExpressionResolverResourceDefinition
extends SimpleResourceDefinition {
    private static final StandardResourceDescriptionResolver RESOURCE_RESOLVER = ElytronExtension.getResourceDescriptionResolver("expression", "encryption");
    private static final SimpleAttributeDefinition NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name", ModelType.STRING, false).setAllowExpression(false)).setMinSize(1)).setRestartAllServices()).build();
    private static final SimpleAttributeDefinition CREDENTIAL_STORE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("credential-store", ModelType.STRING, false).setAllowExpression(false)).setMinSize(1)).setRestartAllServices()).setCapabilityReference("org.wildfly.security.credential-store", "org.wildfly.controller.expression-resolver")).build();
    private static final SimpleAttributeDefinition SECRET_KEY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("secret-key", ModelType.STRING, false).setAllowExpression(false)).setMinSize(1)).setRestartAllServices()).build();
    private static final ObjectTypeAttributeDefinition RESOLVER = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("resolver", new AttributeDefinition[]{NAME, CREDENTIAL_STORE, SECRET_KEY}).setRequired(true)).setRestartAllServices()).build();
    static final ObjectListAttributeDefinition RESOLVERS = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("resolvers", RESOLVER).setRequired(true)).setMinSize(1)).setAttributeParser(AttributeParser.UNWRAPPED_OBJECT_LIST_PARSER)).setAttributeMarshaller(AttributeMarshaller.UNWRAPPED_OBJECT_LIST_MARSHALLER)).build();
    static final SimpleAttributeDefinition DEFAULT_RESOLVER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("default-resolver", ModelType.STRING, true).setAllowExpression(false)).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition PREFIX = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("prefix", ModelType.STRING, true).setAllowExpression(false)).setDefaultValue(new ModelNode("ENC"))).setMinSize(1)).setRestartAllServices()).build();
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{RESOLVERS, DEFAULT_RESOLVER, PREFIX};
    static final SimpleAttributeDefinition RESOLVER_PARAM = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("resolver", ModelType.STRING, true).setMinSize(1)).build();
    static final SimpleAttributeDefinition CLEAR_TEXT = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("clear-text", ModelType.STRING, false).setMinSize(1)).build();
    static final SimpleOperationDefinition CREATE_EXPRESSION = new SimpleOperationDefinitionBuilder("create-expression", (ResourceDescriptionResolver)RESOURCE_RESOLVER).setParameters(new AttributeDefinition[]{RESOLVER_PARAM, CLEAR_TEXT}).setRuntimeOnly().build();

    ExpressionResolverResourceDefinition(OperationStepHandler add, OperationStepHandler remove, RuntimeCapability<ExpressionResolver> expressionResolverRuntimeCapability) {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"expression", (String)"encryption"), (ResourceDescriptionResolver)RESOURCE_RESOLVER).setAddHandler(add).setRemoveHandler(remove).setAddRestartLevel(OperationEntry.Flag.RESTART_ALL_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_ALL_SERVICES).setCapabilities(new RuntimeCapability[]{expressionResolverRuntimeCapability}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ElytronReloadRequiredWriteAttributeHandler write = new ElytronReloadRequiredWriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition current : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)write);
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        if (ElytronExtension.isServerOrHostController((ImmutableManagementResourceRegistration)resourceRegistration)) {
            resourceRegistration.registerOperationHandler((OperationDefinition)CREATE_EXPRESSION, (OperationStepHandler)new CreateExpressionHandler());
        }
    }

    static void configureExpressionResolver(PathAddress resourceAddress, ElytronExpressionResolver expressionResolver, OperationContext context) throws OperationFailedException {
        ModelNode expressionEncryption = context.readResourceFromRoot(resourceAddress).getModel();
        String prefix = PREFIX.resolveModelAttribute(context, expressionEncryption).asString();
        String defaultResolver = DEFAULT_RESOLVER.resolveModelAttribute(context, expressionEncryption).asStringOrNull();
        HashMap<String, ElytronExpressionResolver.ResolverConfiguration> resolverConfigurations = new HashMap<String, ElytronExpressionResolver.ResolverConfiguration>();
        for (ModelNode currentResolver : RESOLVERS.resolveModelAttribute(context, expressionEncryption).asList()) {
            String name = NAME.resolveModelAttribute(context, currentResolver).asString();
            String credentialStoreName = CREDENTIAL_STORE.resolveModelAttribute(context, currentResolver).asString();
            String alias = SECRET_KEY.resolveModelAttribute(context, currentResolver).asString();
            resolverConfigurations.put(name, new ElytronExpressionResolver.ResolverConfiguration(credentialStoreName, alias));
        }
        expressionResolver.setPrefix(prefix).setDefaultResolver(defaultResolver).setResolverConfigurations(resolverConfigurations);
    }

    static ResourceDefinition getExpressionResolverDefinition(PathAddress parentAddress) {
        PathAddress resourceAddress = parentAddress.append(new PathElement[]{PathElement.pathElement((String)"expression", (String)"encryption")});
        ElytronExpressionResolver expressionResolver = new ElytronExpressionResolver((ExceptionBiConsumer<ElytronExpressionResolver, OperationContext, OperationFailedException>)((ExceptionBiConsumer)(e, c) -> ExpressionResolverResourceDefinition.configureExpressionResolver(resourceAddress, e, c)));
        RuntimeCapability expressionResolverRuntimeCapability = RuntimeCapability.Builder.of((String)"org.wildfly.controller.expression-resolver", (boolean)false, (Object)expressionResolver).build();
        ExpressionResolverAddHandler add = new ExpressionResolverAddHandler((RuntimeCapability<ExpressionResolver>)expressionResolverRuntimeCapability);
        TrivialCapabilityServiceRemoveHandler remove = new TrivialCapabilityServiceRemoveHandler(add, expressionResolverRuntimeCapability);
        return new ExpressionResolverResourceDefinition(add, remove, (RuntimeCapability<ExpressionResolver>)expressionResolverRuntimeCapability);
    }

    private static class CreateExpressionHandler
    extends ElytronRuntimeOnlyHandler {
        private CreateExpressionHandler() {
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            String resolver = RESOLVER_PARAM.resolveModelAttribute(context, operation).asStringOrNull();
            String clearText = CLEAR_TEXT.resolveModelAttribute(context, operation).asString();
            ExpressionResolver expressionResolver = (ExpressionResolver)context.getCapabilityRuntimeAPI("org.wildfly.controller.expression-resolver", ExpressionResolver.class);
            String expression = ((ElytronExpressionResolver)expressionResolver).createExpression(resolver, clearText, context);
            context.getResult().get("expression").set(expression);
        }
    }

    private static class ExpressionResolverAddHandler
    extends BaseAddHandler {
        ExpressionResolverAddHandler(RuntimeCapability<ExpressionResolver> expressionResolverRuntimeCapability) {
            super(expressionResolverRuntimeCapability, ATTRIBUTES);
        }

        @Override
        protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            super.recordCapabilitiesAndRequirements(context, operation, resource);
        }
    }
}

