/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.util.HashSet;
import java.util.Set;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.resources.DefaultResourceLoader;
import org.jboss.weld.resources.WeldClassLoaderResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.util.ServiceLoader;
import org.jboss.weld.util.Services;

class AdditionalServiceLoader {
    private final Deployment deployment;

    AdditionalServiceLoader(Deployment deployment) {
        this.deployment = deployment;
    }

    void loadAdditionalServices(ServiceRegistry registry) {
        for (ResourceLoader loader : this.getResourceLoaders()) {
            for (Metadata<Service> metadata : ServiceLoader.load(Service.class, loader)) {
                Service service = (Service)metadata.getValue();
                for (Class<? extends Service> serviceInterface : Services.identifyServiceInterfaces(service.getClass(), new HashSet<Class<? extends Service>>())) {
                    Services.put(registry, serviceInterface, service);
                }
            }
        }
    }

    private Set<ResourceLoader> getResourceLoaders() {
        HashSet<ResourceLoader> resourceLoaders = new HashSet<ResourceLoader>();
        for (BeanDeploymentArchive archive : this.deployment.getBeanDeploymentArchives()) {
            ResourceLoader resourceLoader = (ResourceLoader)archive.getServices().get(ResourceLoader.class);
            if (resourceLoader == null) continue;
            resourceLoaders.add(resourceLoader);
        }
        resourceLoaders.add(WeldClassLoaderResourceLoader.INSTANCE);
        resourceLoaders.add(DefaultResourceLoader.INSTANCE);
        return resourceLoaders;
    }
}

