/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client.impl;

import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.eclipse.microprofile.rest.client.ext.QueryParamStyle;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.ResteasyUriBuilder;
import org.jboss.resteasy.util.Encode;

public class MpUriBuilder
extends ResteasyUriBuilder {
    private QueryParamStyle queryParamStyle = null;

    public MpUriBuilder() {
    }

    public MpUriBuilder(String host, String scheme, int port, String userInfo, String path, String query, String fragment, String ssp, String authority) {
        super(host, scheme, port, userInfo, path, query, fragment, ssp, authority);
    }

    public void setQueryParamStyle(QueryParamStyle queryParamStyle) {
        this.queryParamStyle = queryParamStyle;
    }

    public UriBuilder clone() {
        MpUriBuilder builder = new MpUriBuilder(this.getHost(), this.getScheme(), this.getPort(), this.getUserInfo(), this.getPath(), this.getQuery(), this.getFragment(), this.getSsp(), this.getAuthority());
        builder.setQueryParamStyle(this.queryParamStyle);
        return builder;
    }

    public UriBuilder clientQueryParam(String name, Object ... values) throws IllegalArgumentException {
        UriBuilder uriBuilder = null;
        switch (this.queryParamStyle) {
            case COMMA_SEPARATED: {
                this.clientQueryParamCommaSeparated(name, values);
                break;
            }
            case ARRAY_PAIRS: {
                this.clientQueryParamArrayPairs(name, values);
                break;
            }
            default: {
                uriBuilder = super.clientQueryParam(name, values);
            }
        }
        return uriBuilder;
    }

    private UriBuilder clientQueryParamCommaSeparated(String name, Object ... values) throws IllegalArgumentException {
        String query = this.getQuery();
        StringBuilder sb = new StringBuilder();
        if (query == null) {
            query = "";
        } else {
            sb.append(query).append("&");
        }
        if (name == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.nameParameterNull());
        }
        if (values == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.valuesParameterNull());
        }
        sb.append(Encode.encodeQueryParamAsIs((String)name)).append("=");
        int cntDown = values.length - 1;
        for (Object value : values) {
            if (value == null) {
                throw new IllegalArgumentException(Messages.MESSAGES.passedInValueNull());
            }
            sb.append(Encode.encodeQueryParamAsIs((String)value.toString()));
            if (cntDown <= 0) continue;
            sb.append(",");
            --cntDown;
        }
        this.replaceQueryNoEncoding(sb.toString());
        return this;
    }

    private UriBuilder clientQueryParamArrayPairs(String name, Object ... values) throws IllegalArgumentException {
        String query = this.getQuery();
        StringBuilder sb = new StringBuilder();
        String prefix = "";
        if (query == null) {
            query = "";
        } else {
            sb.append(query).append("&");
        }
        if (name == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.nameParameterNull());
        }
        if (values == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.valuesParameterNull());
        }
        for (Object value : values) {
            if (value == null) {
                throw new IllegalArgumentException(Messages.MESSAGES.passedInValueNull());
            }
            sb.append(prefix);
            prefix = "&";
            sb.append(Encode.encodeQueryParamAsIs((String)name)).append("[]=").append(Encode.encodeQueryParamAsIs((String)value.toString()));
        }
        this.replaceQueryNoEncoding(sb.toString());
        return this;
    }

    public UriBuilder uri(String uriTemplate, QueryParamStyle queryParamStyle) throws IllegalArgumentException {
        this.queryParamStyle = queryParamStyle;
        return this.uriTemplate(uriTemplate);
    }

    public UriBuilder uri(URI uri, QueryParamStyle queryParamStyle) throws IllegalArgumentException {
        this.queryParamStyle = queryParamStyle;
        return this.uri(uri);
    }
}

