/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.fault;

import io.smallrye.reactive.messaging.kafka.IncomingKafkaRecord;
import io.smallrye.reactive.messaging.kafka.fault.KafkaFailureHandler;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaLogging;
import io.smallrye.reactive.messaging.kafka.impl.KafkaSource;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class KafkaFailStop
implements KafkaFailureHandler {
    private final String channel;
    private final KafkaSource<?, ?> source;

    public <K, V> KafkaFailStop(String channel, KafkaSource<?, ?> source) {
        this.channel = channel;
        this.source = source;
    }

    @Override
    public <K, V> CompletionStage<Void> handle(IncomingKafkaRecord<K, V> record, Throwable reason) {
        KafkaLogging.log.messageNackedFailStop(this.channel);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        future.completeExceptionally(reason);
        this.source.reportFailure(reason, true);
        return future;
    }
}

