/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial.impl;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

abstract class ConstantScoreWeight
extends Weight {
    private float boost;
    private float queryNorm;
    private float queryWeight;

    protected ConstantScoreWeight(Query query) {
        super(query);
        this.normalize(1.0f, 1.0f);
    }

    public void extractTerms(Set<Term> terms) {
    }

    public final float getValueForNormalization() throws IOException {
        return this.queryWeight * this.queryWeight;
    }

    public void normalize(float norm, float boost) {
        this.boost = boost;
        this.queryNorm = norm;
        this.queryWeight = this.queryNorm * boost;
    }

    protected final float score() {
        return this.queryWeight;
    }

    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        boolean exists;
        Scorer s = this.scorer(context);
        if (s == null) {
            exists = false;
        } else {
            TwoPhaseIterator twoPhase = s.twoPhaseIterator();
            if (twoPhase == null) {
                exists = s.iterator().advance(doc) == doc;
            } else {
                boolean bl = exists = twoPhase.approximation().advance(doc) == doc && twoPhase.matches();
            }
        }
        if (exists) {
            return Explanation.match((float)this.queryWeight, (String)(this.getQuery().toString() + ", product of:"), (Explanation[])new Explanation[]{Explanation.match((float)this.boost, (String)"boost", (Explanation[])new Explanation[0]), Explanation.match((float)this.queryNorm, (String)"queryNorm", (Explanation[])new Explanation[0])});
        }
        return Explanation.noMatch((String)(this.getQuery().toString() + " doesn't match id " + doc), (Explanation[])new Explanation[0]);
    }
}

