/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.OptionalInt;
import java.util.function.Supplier;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.wildfly.clustering.marshalling.protostream.EnumMarshaller;
import org.wildfly.clustering.marshalling.protostream.Marshallable;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import protostream.com.google.protobuf.CodedOutputStream;

public class SizeComputingProtoStreamWriter
implements ProtoStreamWriter,
Supplier<OptionalInt> {
    private final ImmutableSerializationContext context;
    private int size = 0;
    private boolean present = true;

    public SizeComputingProtoStreamWriter(ImmutableSerializationContext context) {
        this.context = context;
    }

    @Override
    public OptionalInt get() {
        return this.present ? OptionalInt.of(this.size) : OptionalInt.empty();
    }

    @Override
    public ImmutableSerializationContext getSerializationContext() {
        return this.context;
    }

    public void writeTag(int index, int wireType) {
        if (this.present) {
            this.size += CodedOutputStream.computeTagSize((int)index);
        }
    }

    public void writeUInt32NoTag(int value) {
        if (this.present) {
            this.size += CodedOutputStream.computeUInt32SizeNoTag((int)value);
        }
    }

    public void writeUInt64NoTag(long value) {
        if (this.present) {
            this.size += CodedOutputStream.computeUInt64SizeNoTag((long)value);
        }
    }

    public void writeString(int index, String value) {
        if (this.present) {
            this.size += CodedOutputStream.computeStringSize((int)index, (String)value);
        }
    }

    public void writeInt32(int index, int value) {
        if (this.present) {
            this.size += CodedOutputStream.computeInt32Size((int)index, (int)value);
        }
    }

    public void writeFixed32(int index, int value) {
        if (this.present) {
            this.size += CodedOutputStream.computeFixed32Size((int)index, (int)value);
        }
    }

    public void writeUInt32(int index, int value) {
        if (this.present) {
            this.size += CodedOutputStream.computeUInt32Size((int)index, (int)value);
        }
    }

    public void writeSFixed32(int index, int value) {
        if (this.present) {
            this.size += CodedOutputStream.computeSFixed32Size((int)index, (int)value);
        }
    }

    public void writeSInt32(int index, int value) {
        if (this.present) {
            this.size += CodedOutputStream.computeSInt32Size((int)index, (int)value);
        }
    }

    public void writeInt64(int index, long value) {
        if (this.present) {
            this.size += CodedOutputStream.computeInt64Size((int)index, (long)value);
        }
    }

    public void writeUInt64(int index, long value) {
        if (this.present) {
            this.size += CodedOutputStream.computeUInt64Size((int)index, (long)value);
        }
    }

    public void writeFixed64(int index, long value) {
        if (this.present) {
            this.size += CodedOutputStream.computeFixed64Size((int)index, (long)value);
        }
    }

    public void writeSFixed64(int index, long value) {
        if (this.present) {
            this.size += CodedOutputStream.computeSFixed64Size((int)index, (long)value);
        }
    }

    public void writeSInt64(int index, long value) {
        if (this.present) {
            this.size += CodedOutputStream.computeSInt64Size((int)index, (long)value);
        }
    }

    public void writeEnum(int index, int value) {
        if (this.present) {
            this.size += CodedOutputStream.computeEnumSize((int)index, (int)value);
        }
    }

    public void writeBool(int index, boolean value) {
        if (this.present) {
            this.size += CodedOutputStream.computeBoolSize((int)index, (boolean)value);
        }
    }

    public void writeDouble(int index, double value) {
        if (this.present) {
            this.size += CodedOutputStream.computeDoubleSize((int)index, (double)value);
        }
    }

    public void writeFloat(int index, float value) {
        if (this.present) {
            this.size += CodedOutputStream.computeFloatSize((int)index, (float)value);
        }
    }

    public void writeBytes(int index, ByteBuffer value) {
        if (this.present) {
            this.size += CodedOutputStream.computeByteBufferSize((int)index, (ByteBuffer)value);
        }
    }

    public void writeBytes(int index, byte[] value) {
        if (this.present) {
            this.size += CodedOutputStream.computeByteArraySize((int)index, (byte[])value);
        }
    }

    public void writeBytes(int index, byte[] value, int offset, int length) {
        if (this.present) {
            this.writeBytes(index, ByteBuffer.wrap(value, offset, length));
        }
    }

    public void writeRawBytes(byte[] value, int offset, int length) {
        if (this.present) {
            this.size += CodedOutputStream.computeByteBufferSizeNoTag((ByteBuffer)ByteBuffer.wrap(value, offset, length));
        }
    }

    public void flush() {
    }

    @Override
    public void writeObject(int index, Object value) {
        if (this.present) {
            this.size += CodedOutputStream.computeTagSize((int)index);
            this.writeObjectNoTag(value);
        }
    }

    @Override
    public void writeObjectNoTag(Object value) {
        if (this.present) {
            OptionalInt size;
            BaseMarshaller marshaller = this.context.getMarshaller(value.getClass());
            OptionalInt optionalInt = size = marshaller instanceof Marshallable ? ((Marshallable)marshaller).size(this.context, value) : OptionalInt.empty();
            if (size.isPresent()) {
                this.size += CodedOutputStream.computeUInt32SizeNoTag((int)size.getAsInt()) + size.getAsInt();
            } else {
                this.present = false;
            }
        }
    }

    @Override
    public <E extends Enum<E>> void writeEnum(int index, E value) throws IOException {
        if (this.present) {
            EnumMarshaller marshaller = (EnumMarshaller)this.context.getMarshaller(value.getDeclaringClass());
            this.size += CodedOutputStream.computeEnumSize((int)index, (int)marshaller.encode(value));
        }
    }

    @Override
    public void writeStringNoTag(String value) {
        if (this.present) {
            this.size += CodedOutputStream.computeStringSizeNoTag((String)value);
        }
    }

    @Override
    public void writeBoolNoTag(boolean value) throws IOException {
        if (this.present) {
            this.size += CodedOutputStream.computeBoolSizeNoTag((boolean)value);
        }
    }

    @Override
    public void writeSInt32NoTag(int value) throws IOException {
        if (this.present) {
            this.size += CodedOutputStream.computeSInt32SizeNoTag((int)value);
        }
    }

    @Override
    public void writeSInt64NoTag(long value) throws IOException {
        if (this.present) {
            this.size += CodedOutputStream.computeSInt64SizeNoTag((long)value);
        }
    }

    @Override
    public void writeFloatNoTag(float value) throws IOException {
        if (this.present) {
            this.size += CodedOutputStream.computeFloatSizeNoTag((float)value);
        }
    }

    @Override
    public void writeDoubleNoTag(double value) throws IOException {
        if (this.present) {
            this.size += CodedOutputStream.computeDoubleSizeNoTag((double)value);
        }
    }

    @Override
    public void writeRawByte(byte value) throws IOException {
        if (this.present) {
            ++this.size;
        }
    }
}

